<style>
    .fa-cart-shopping:before,
    .fa-shopping-cart:before {
        color: #0B8CD4;
    }

    .apply-btn {
        transition: all 0.3s ease-in-out;
    }

    .apply-btn:hover {
        background-color: #0B8CD4;
        /* slightly darker shade */
        transform: translateY(-2px);
        /* lift effect */
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
    }
</style>
<!--breadcrumb section end-->
<!--cart section start-->
<section class="cart-section ptb-80 bg-light pt-5" style="margin-bottom: 200px;">
    <div class="container">

        <?php if ($this->session->userdata('yid')): ?>

            <!-- Cart Header -->
            <div class="d-flex align-items-center justify-content-between bg-white rounded-3 shadow-sm p-4">
                <h4 class="mb-0"><i class="fa-solid fa-cart-shopping me-2 text-primary"></i> Your Shopping Cart</h4>

                <form onsubmit="return ajaxsubmitform('<?= base_url('e_com/clearCartSession') ?>', this,'error_div','loder_div','#','1','clearsession');"
                    action="<?= base_url('cart') ?>" method="post">
                    <button class="btn btn-outline-danger btn-sm rounded-2" type="submit">
                        <i class="fa-solid fa-trash-can me-1"></i> Clear Cart
                    </button>
                </form>
            </div>

            <!-- Cart Table -->
            <div class="rounded-3 shadow-sm overflow-hidden mt-4">
                <table class="table table-bordered align-middle mb-0">
                    <thead class="table-light text-center">
                        <tr>
                            <th><i class="fa fa-trash"></i></th>
                            <th>Image</th>
                            <th>Product</th>
                            <th>Qty</th>
                            <th>Unit Price</th>
                            <th>Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (isset($_SESSION['ecom_cart']) && count($_SESSION['ecom_cart']) >= 1):
                            $subtotal = 0;
                            foreach ($_SESSION['ecom_cart'] as $pro):
                                $subtotal += $pro['p_price'] * $pro['p_qty'];
                                $productUrl = base_url('product/') . $pro['p_id'] . '/' . url_smart($pro['p_name']);
                        ?>
                                <tr>
                                    <td class="text-center">
                                        <form method="post" action="<?= base_url('index.php/action/remove_cart') ?>">
                                            <input type="hidden" name="productId" value="<?= $pro['p_id'] ?>">
                                            <button class="btn btn-sm btn-outline-danger" aria-label="Remove" type="submit">
                                                <i class="fa fa-times"></i>
                                            </button>
                                        </form>
                                    </td>
                                    <td class="text-center">
                                        <img width="80" src="<?= base_url('assets/avator/upload/') . $pro['p_img'] ?>"
                                            alt="product-thumb" class="img-fluid rounded">
                                    </td>
                                    <td>
                                        <a href="<?= $productUrl ?>" class="fw-semibold text-dark text-decoration-none">
                                            <?= $pro['p_name'] ?>
                                        </a>
                                    </td>
                                    <td class="text-center fw-bold"><?= $pro['p_qty'] ?></td>
                                    <td class="text-center fw-bold"><?= money_show($pro['p_price']) ?></td>
                                    <td class="text-center fw-bold text-success"><?= money_show($pro['p_price'] * $pro['p_qty']) ?></td>
                                </tr>
                            <?php endforeach;
                        else: ?>
                            <tr>
                                <td colspan="6" class="text-center py-5">🛒 Your cart is empty!</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- Coupon & Order Summary -->
            <div class="row g-4 mt-4">

                <!-- Coupon Section -->
                <div class="col-xl-7">
                    <div class="voucher-box position-relative bg-white rounded-3 shadow-sm p-4 h-100">
                        <h5 class="mb-3 fw-semibold">Have a Coupon?</h5>

                        <?php if (isset($_SESSION['coupon_code']) && $_SESSION['coupon_code'] != ''): ?>
                            <div class="alert alert-success d-flex justify-content-between align-items-center" role="alert">
                                <span>Code <strong><?= $_SESSION['coupon_code'] ?></strong> applied.</span>
                                <a href="action/remove_coupon" class="btn btn-sm btn-outline-danger">
                                    <i class="fa fa-trash"></i>
                                </a>
                            </div>
                        <?php else: ?>
                            <p class="mb-3 small text-muted">Enter your discount code below if you have one.</p>
                            <form class="d-flex gap-2"
                                action="<?= base_url('action/coupon_check') ?>"
                                onsubmit="return ajaxsubmitform('<?= base_url('index.php/action/coupon_check') ?>',this,'error_div','loder_div','#','1','coupon');">
                                <input type="text" placeholder="Coupon Code" name="coupon" class="form-control">
                                <button type="submit" class="btn apply-btn" style="background-color: #0B8CD4; color:white;">
                                    Apply
                                </button>
                            </form>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Cart Summary Section -->
                <div class="col-xl-5">
                    <div class="cart-summery bg-white rounded-3 shadow-sm p-4">
                        <h5 class="fw-semibold mb-3">Order Summary</h5>
                        <table class="table table-borderless mb-0">
                            <tr>
                                <td>Subtotal</td>
                                <td class="text-end"><?= money_show($subtotal, 2) ?></td>
                            </tr>
                            <?php
                            $coupon_discount = isset($_SESSION['sesssion_coupn_temp']) ? $_SESSION['sesssion_coupn_temp'] : 0;
                            if ($coupon_discount > 0): ?>
                                <tr>
                                    <td>Coupon Discount</td>
                                    <td class="text-end text-success">- <?= money_show($coupon_discount) ?></td>
                                </tr>
                            <?php endif; ?>
                            <tr class="border-top">
                                <td class="fw-bold">Total</td>
                                <td class="fw-bold text-end" style="color: #0B8CD4;">
                                    <?= money_show(is_numeric($coupon_discount) ? ($subtotal - $coupon_discount) : $subtotal) ?>
                                </td>
                            </tr>
                        </table>

                        <!-- Terms & Confirm -->
                        <div class="form-check mt-4">
                            <input type="radio" class="form-check-input" id="saveinformation" required>
                            <label class="form-check-label small text-muted" for="saveinformation">
                                I agree with the <a href="<?= base_url('terms') ?>" class="text-decoration-underline">terms and conditions</a>
                            </label>
                        </div>

                        <div class="d-flex gap-3 mt-4">
                            <button type="button" class="btn zoom-btn w-50" onclick="confirmOrder()" style="background-color:#0B8CD4; color:white;">
                                Confirm Order
                            </button>
                            <a href="<?= base_url('shop') ?>" class="btn btn-outline-secondary w-50 zoom-btn">Continue Shopping</a>
                        </div>

                        <style>
                            .zoom-btn {
                                transition: transform 0.3s ease, box-shadow 0.3s ease;
                            }

                            .zoom-btn:hover {
                                transform: scale(1.05);
                                box-shadow: 0 6px 15px rgba(0, 0, 0, 0.2);
                            }

                            .zoom-btn:active {
                                transform: scale(0.97);
                            }
                        </style>
                    </div>
                </div>

            </div>

        <?php else: ?>
            <div class="text-center py-5">
                <p>Please <a href="<?= base_url('login') ?>">log in</a> to view your shopping cart.</p>
            </div>
        <?php endif; ?>

    </div>
</section>
<!--cart section end-->

<script>
    function confirmOrder() {
        var radioBtn = document.getElementById('saveinformation');
        if (radioBtn.checked) {
            window.location.href = '<?= base_url('checkout') ?>';
        } else {
            alert('Please agree to the terms and conditions before confirming the order.');
        }
    }
</script>