<style>
	.header-logo {
		max-width: 100%;
		height: auto;

		display: block;

	}


	@media (min-width: 1200px) {
		.header-logo {
			max-width: 80px;

		}
	}

	.pay-btn {
		background-color: #7CD1F9;
		color: #fff;
		border: none;
		padding: 12px 25px;
		font-size: 16px;
		border-radius: 8px;
		cursor: pointer;
		transition: 0.3s;
	}

	.pay-btn:hover {
		background-color: #5cbde6;
	}

	.bg-primary {

		background-color: #0391DD !important;
	}

	.form-label {
		font-size: 15px;
	}



	.header-top-section,
	.footer-section,
	.box-nav-category,
	.header-sticky,
	.header-1 {
		display: none !important;
	}

	#navbar {
		display: none !important;
	}

	.header-top-section {
		display: none;
	}

	.offcanvas-search {
		display: none;
	}

	.mb-1,
	.mb-4,
	.mb-3 {
		font-size: 22px;

	}
</style>
<style>
	:root {
		--primary-color: #0391DD;
		--secondary-color: #f8f9fa;
		--accent-color: #e74c3c;
		--text-color: #333;
		--border-color: #dee2e6;
	}



	body {
		font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
		color: var(--text-color);
		background-color: #f9fafb;
	}

	.checkout-container {
		max-width: 1400px;
		margin: 0 auto;
	}


	.cart-icon {
		position: relative;
		display: inline-block;
	}

	.cart-badge {
		position: absolute;
		top: -8px;
		right: -8px;
		font-size: 0.7rem;
		padding: 0.25rem 0.5rem;
	}

	.checkout-section {
		padding: 2rem 0;
	}

	.form-control,
	.form-select {
		padding: 0.875rem 1rem;
		border-radius: 0.5rem;
		border: 1px solid var(--border-color);
		transition: all 0.3s;
	}

	.form-control:focus,
	.form-select:focus {
		border-color: var(--primary-color);
		box-shadow: 0 0 0 0.25rem rgba(52, 152, 219, 0.25);
	}

	.input-group-text {
		background-color: transparent;
		border-radius: 0.5rem;
	}

	.btn-primary {
		background-color: #0391DD;
		border-color: #0391DD;
		padding: 0.875rem 1.5rem;
		border-radius: 0.5rem;
		font-weight: 600;
		transition: all 0.3s;
	}

	.btn-primary:hover {
		background-color: linear-gradient(90deg, #251660, #0391DD);
		border-color: #0391DD;
		transform: translateY(-2px);
	}

	.cart-item {
		border-bottom: 1px solid var(--border-color);
		padding: 1rem 0;
	}

	.cart-item:last-child {
		border-bottom: none;
	}

	.checkout-sidebar {
		background-color: white;
		border-radius: 1rem;
		padding: 1.5rem;
		box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
	}

	.hr-line {
		border-top: 1px dashed var(--border-color);
		margin: 0.5rem 0;
	}

	.policy-links a {
		color: #6c757d;
		text-decoration: none;
		font-size: 0.875rem;
		transition: color 0.3s;
	}

	.policy-links a:hover {
		color: var(--primary-color);
	}

	.shipping-option {
		border: 1px solid var(--border-color);
		border-radius: 0.5rem;
		padding: 0.75rem;
		margin-bottom: 1rem;
		cursor: pointer;
		transition: all 0.3s;
	}

	.shipping-option:hover,
	.shipping-option.selected {
		border-color: var(--primary-color);
		background-color: rgba(52, 152, 219, 0.05);
	}

	.shipping-option input[type="radio"] {
		margin-right: 0.5rem;
	}

	/* Responsive adjustments */
	@media (max-width: 768px) {
		.border-right {
			border-right: none !important;
		}

		.mobile-margin {
			margin-top: 2rem;
		}

		.checkout-sidebar {
			padding: 1rem;
		}

		.policy-links .nav-item {
			display: inline-block;
			margin-right: 1rem;
			margin-bottom: 0.5rem;
		}
	}

	@media (max-width: 576px) {
		.form-group .row>div {
			margin-bottom: 1rem;
		}

		.btn-primary {
			width: 100%;
		}
	}

	/* Animation for form elements */
	.form-group {
		margin-bottom: 1.5rem;
	}

	.form-label {
		font-weight: 500;
		margin-bottom: 0.5rem;
		display: block;
	}

	/* Toggle animation */
	#apartmentInput {
		transition: all 0.3s ease;
	}

	/* Loading animation */
	.loading {
		display: inline-block;
		width: 20px;
		height: 20px;
		border: 3px solid rgba(255, 255, 255, .3);
		border-radius: 50%;
		border-top-color: #fff;
		animation: spin 1s ease-in-out infinite;
	}

	@keyframes spin {
		to {
			transform: rotate(360deg);
		}
	}
</style>

<body>
	<!-- Header -->
	<div class="container-fluid border-bottom bg-white sticky-top">
		<div class="container py-2">
			<div class="row align-items-center">
				<div class="col-6">
					<a href="<?= base_url() ?>">
						<img src="<?= base_url('assets/avator/logo_light.png') ?>" alt="logo" class="header-logo">
					</a>
				</div>
				<div class="col-6 text-end">
					<a href="<?= base_url('cart') ?>" class="cart-icon">
						<svg width="24" height="28" viewBox="0 0 22 25" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
							<path d="M21.1704 23.9559L19.6264 7.01422C19.5843 6.55156 19.1908 6.19718 18.7194 6.19718H15.5355V4.78227C15.5355 2.14533 13.3583 0 10.6823 0C8.00628 0 5.82937 2.14533 5.82937 4.78227V6.19718H2.6433C2.17192 6.19718 1.77839 6.55156 1.73625 7.01422L0.186259 24.0225C0.163431 24.2735 0.248671 24.5223 0.421216 24.7082C0.593761 24.8941 0.837705 25 1.0933 25H20.2695C20.2702 25 20.2712 25 20.2719 25C20.775 25 21.1826 24.5982 21.1826 24.1027C21.1825 24.0528 21.1784 24.0036 21.1704 23.9559ZM7.65075 4.78227C7.65075 3.1349 9.01071 1.79465 10.6824 1.79465C12.3542 1.79465 13.7142 3.1349 13.7142 4.78227V6.19718H7.65075V4.78227ZM2.08948 23.2055L3.47591 7.99183H5.82937V9.59649C5.82937 10.0921 6.237 10.4938 6.74006 10.4938C7.24313 10.4938 7.65075 10.0921 7.65075 9.59649V7.99183H13.7142V9.59649C13.7142 10.0921 14.1219 10.4938 14.6249 10.4938C15.128 10.4938 15.5356 10.0921 15.5356 9.59649V7.99183H17.8869L19.2733 23.2055H2.08948Z" />
						</svg>
						<?php if (isset($_SESSION['ecom_cart']) && count($_SESSION['ecom_cart']) >= 1) { ?>
							<span class="cart-badge badge bg-primary"><?= count($_SESSION['ecom_cart']) ?></span>
						<?php } ?>
					</a>
				</div>
			</div>
		</div>
	</div>

	<!-- Checkout Section -->
	<?php if (isset($_SESSION['ecom_cart']) && count($_SESSION['ecom_cart']) >= 1) { ?>
		<div class="checkout-section">
			<div class="checkout-container">
				<div class="row g-4">
					<!-- Left Column - Form -->
					<div class="col-lg-7 col-md-6">
						<div class="p-3 p-md-4 bg-white rounded shadow-sm">
							<div class="row align-items-center mb-4">
								<div class="col-md-6">
									<h2 class="mb-1">Contact Information</h2>
								</div>
								<?php if (!isset($_SESSION['yid'])) { ?>
									<div class="col-md-6 text-md-end">
										<p class="mb-0">Have an account? <a href="<?= base_url('login') ?>" class="text-primary text-decoration-underline">Log in</a></p>
									</div>
								<?php } ?>
							</div>
							<form id="paymentForm"
								action=""
								method="POST"
								onsubmit="return handleCheckoutSubmit(event)">

								<div class="row">
									<div class="col-md-12">

										<div class="form-group">
											<div class="form-group">
												<input type="email"
													name="email"
													class="form-control"
													id="contactInput"
													placeholder="Enter your Email"
													style="background-color: white !important;"
													value="<?= isset($_SESSION['email']) ? $_SESSION['email'] : '' ?>">
											</div>
										</div>

									</div>
								</div>

								<div>
									<h2 class="mb-1">Delivery</h2>
								</div>

								<div class="form-group delivery" id="shipField">
									<div class="form-check d-flex align-items-center">
										<input class="form-check-input" type="radio" name="shippingType" value="ship" checked>
										<label class="form-check-label ms-2">Ship</label>
										<i class="bi bi-truck ms-auto"></i>
									</div>
								</div>
								<div class="my-10" id="shipForm" style="display: block;">
									<!-- Shipping related fields -->
									<div class="form-group my-3 row">
										<div class="col-md-6 my-3">
											<div class="input-group">
												<input type="text"
													name="ecom_order_name"
													id="full_name"
													class="form-control"
													placeholder="Full Name*"
													required
													value="<?= isset($_SESSION['name']) ? $_SESSION['name'] : '' ?>">
											</div>
										</div>

										<div class="col-md-6 my-3">
											<input type="text"
												class="form-control"
												style="margin-left:1px"
												name="phone"
												id="f_phone"
												placeholder="Phone*"
												required
												value="<?= isset($_SESSION['phone']) ? $_SESSION['phone'] : '' ?>">
										</div>


										<div class="col-md-12 my-3">
											<div class="input-group">
												<input type="text" class="form-control" name="address" placeholder="Full Address">
												<div class="input-group-append position-absolute" style="top:30%; right:10px">

												</div>
											</div>
										</div>
									</div>
									<div class="form-group my-3">
										<p style="color:blue" id="addApartmentLink" onclick="toggleApartmentInput()">
											<i class="bi bi-plus"></i> Add apartment, suite, etc.
										</p>
									</div>
									<div class="form-group mt-3" id="apartmentInput" style="display: none;">
										<input type="text" name="addr_type" class="form-control" placeholder="Apartment, suite, etc.">
									</div>
									<div class="form-group my-3 row">
										<div class="col-md-4 my-3">
											<input type="text" class="form-control" name="city" placeholder="City">
										</div>

										<div class="col-md-4 my-3">
											<input type="text" class="form-control" name="zip" placeholder="ZIP Code">
										</div>

										<div class="col-md-4 my-3">
											<input type="text" class="form-control" name="state" placeholder="State">
										</div>

									</div>

									<div class="form-group my-3">
										<h5 class="mb-3">Payment Method</h5>
										<div class="row">
											<div class="col-md-6 my-2">
												<div class="form-check">
													<input class="form-check-input" type="radio" name="payment_type" id="payment_cod" value="COD">
													<label class="form-check-label" for="payment_cod">
														Cash on Delivery (COD)
													</label>
												</div>
											</div>
											<div class="col-md-6 my-2">
												<div class="form-check">
													<input class="form-check-input" type="radio" name="payment_type" id="payment_razorpay" value="RAZORPAY" checked>
													<label class="form-check-label" for="payment_razorpay">
														Razorpay (Online Payment)
													</label>
												</div>
											</div>
											<div class="col-md-6 my-2">
												<div class="form-check">
													<input class="form-check-input" type="radio" name="payment_type" id="payment_phonepe" value="PREPAID">
													<label class="form-check-label" for="payment_phonepe">
														PhonePe (Online Payment)
													</label>
												</div>
											</div>
										</div>
									</div>
								</div>

								<button type="submit" class="btn btn-primary btn-md rounded mt-6 w-100">Pay Now</button>
							</form>


						</div>
					</div>

					<!-- Right Column - Order Summary -->
					<div class="col-lg-5 col-md-6 mobile-margin">
						<div class="checkout-sidebar sticky-md-top" style="top: 20px;">
							<h3 class="mb-4">Order Summary</h3>

							<div class="cart-items mb-4">
								<?php
								$totalAmount = 0;
								foreach ($_SESSION['ecom_cart'] as $pro):
									$totalAmount += $pro['p_price'];
								?>
									<div class="cart-item d-flex">
										<div class="flex-shrink-0 d-none d-sm-block me-3">
											<img src="<?= base_url('assets/avator/upload/' . $pro['p_img']) ?>" class="img-fluid rounded" alt="<?= $pro['p_name'] ?>" width="80">

										</div>
										<div class="flex-grow-1">
											<h6 class="my-0"><?= $pro['p_name'] ?></h6>
										</div>
										<div class="text-end">
											<span class="price fw-bold"><?= money_show($pro['p_price']) ?></span>
										</div>
									</div>
								<?php endforeach; ?>
							</div>

							<?php if (isset($_SESSION['coupon_code']) && $_SESSION['coupon_code'] != ''): ?>
								<div class="alert alert-success d-flex justify-content-between align-items-center" role="alert">
									<div>
										Code <strong><?= $_SESSION['coupon_code'] ?></strong> applied
									</div>
									<a href="action/remove_coupon" class="text-danger"><i class="bi bi-trash"></i></a>
								</div>
							<?php else: ?>
								<form method="post" action="<?= base_url('action/coupon_check') ?>" novalidate="novalidate" onsubmit="return ajaxsubmitform('<?= base_url('index.php/action/coupon_check') ?>',this,'error_div','loder_div','#','1','coupon');">
									<div class="input-group mb-10">
										<input type="text" class="form-control" name="coupon" placeholder="Discount Code" style="background-color: #ffffff;">
										<div class="input-group-append">
											<button class="btn btn-primary" type="submit">Apply</button>
										</div>
									</div>
								</form>

							<?php endif; ?>

							<div class="border-top pt-3">
								<?php
								$coupon_discount = 0;
								if (isset($_SESSION['sesssion_coupn_temp'])) {
									$coupon_amount = $_SESSION['sesssion_coupn_temp'];
									$coupon_discount = $coupon_amount;
								}
								?>

								<?php if ($coupon_discount > 0): ?>
									<div class="d-flex justify-content-between mb-2">
										<span>Coupon Discount</span>
										<span class="text-success">- ₹<?= number_format($coupon_discount, 2) ?></span>
									</div>
								<?php endif; ?>

								<div class="d-flex justify-content-between mt-2 pt-2 border-top">
									<strong>Total</strong>
									<strong><?= money_show(getCartAmount_row()) ?></strong>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	<?php } else {
		redirect(base_url('shop'));
	} ?>

	<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
	<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

	<script>
		// Toggle "Add New Address" form
		function toggleApartmentInput() {
			const form = document.getElementById('newAddressForm');
			const link = document.getElementById('addApartmentLink');

			if (form.style.display === 'none' || form.style.display === '') {
				form.style.display = 'block';
				link.innerHTML = '<i class="bi bi-dash-circle"></i> Hide new address field';
			} else {
				form.style.display = 'none';
				link.innerHTML = '<i class="bi bi-plus-circle"></i> Add New Address';
			}
		}

		// Handle checkout form submission (show loader)
		document.getElementById('checkoutForm').addEventListener('submit', function(e) {
			const payButton = document.getElementById('payButton');
			const buttonText = document.getElementById('buttonText');
			const buttonLoader = document.getElementById('buttonLoader');

			buttonText.style.display = 'none';
			buttonLoader.style.display = 'inline-block';
			payButton.disabled = true;
		});

		// Shipping option selection
		document.getElementById('shipOption').addEventListener('click', function() {
			document.getElementById('shipRadio').checked = true;
			document.getElementById('shipOption').classList.add('selected');
		});

		// Make sidebar sticky only on larger screens
		function handleResize() {
			const sidebar = document.querySelector('.checkout-sidebar');
			if (window.innerWidth < 768) {
				sidebar.classList.remove('sticky-md-top');
			} else {
				sidebar.classList.add('sticky-md-top');
			}
		}
		window.addEventListener('resize', handleResize);
		handleResize();

		// Coupon form AJAX handling
		document.getElementById('couponForm').addEventListener('submit', function(e) {
			e.preventDefault();

			var couponCode = document.getElementById('couponCode').value.trim();
			var button = document.getElementById('couponButton');

			var xhr = new XMLHttpRequest();
			xhr.open('POST', '<?= base_url('action/coupon_check') ?>', true);
			xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

			xhr.onreadystatechange = function() {
				if (xhr.readyState === 4) {
					if (xhr.status === 200) {
						var response = xhr.responseText;

						if (response.toLowerCase().includes('success')) {
							button.textContent = 'Applied';
							button.disabled = true;
							button.classList.remove('btn-outline-primary');
							button.classList.add('btn-success');

							Swal.fire({
								title: 'Success!',
								text: response,
								icon: 'success',
								confirmButtonText: 'OK'
							});
						} else {
							Swal.fire({
								title: 'Oops!',
								text: response,
								icon: 'error',
								confirmButtonText: 'OK'
							});
						}
					} else {
						Swal.fire({
							title: 'Error!',
							text: 'Something went wrong. Please try again!',
							icon: 'error',
							confirmButtonText: 'OK'
						});
					}
				}
			};

			xhr.send('coupon=' + encodeURIComponent(couponCode));
		});
	</script>
	<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
	<script>
		// Handle checkout form submission based on payment gateway
		function handleCheckoutSubmit(e) {
			e.preventDefault();
			
			var paymentType = document.querySelector('input[name="payment_type"]:checked').value;
			var form = document.getElementById('paymentForm');
			
			if (paymentType === 'COD') {
				// Cash on Delivery - submit to phonepe (which handles COD)
				form.action = '<?= base_url('payment/phonepe') ?>';
				form.submit();
			} else if (paymentType === 'RAZORPAY') {
				// Razorpay - submit to razorpay checkout handler
				form.action = '<?= base_url('payment/razorpay_checkout') ?>';
				form.submit();
			} else if (paymentType === 'PREPAID') {
				// PhonePe - submit to phonepe
				form.action = '<?= base_url('payment/phonepe') ?>';
				form.submit();
			} else {
				// Default to PhonePe
				form.action = '<?= base_url('payment/phonepe') ?>';
				form.submit();
			}
			
			return false;
		}

		// Commented out login check - allow checkout without login
		/*
		function checkLogin(e) {
			e.preventDefault();

			var email = document.querySelector("[name='email']").value;

			// Ajax check
			fetch("<?= base_url('payment/check_account_exists') ?>", {
					method: "POST",
					headers: {
						"Content-Type": "application/x-www-form-urlencoded"
					},
					body: "email=" + encodeURIComponent(email)
				})
				.then(res => res.json())
				.then(data => {
					if (data.exists) {
						// registered → allow form to submit
						document.getElementById("paymentForm").submit();
					} else {
						// not registered → show signup alert
						Swal.fire({
							icon: 'warning',
							title: 'Sign Up Required',
							text: 'Please sign up before making payment.',
							confirmButtonText: 'Go to Sign Up',
							confirmButtonColor: '#7CD1F9'
						}).then((result) => {
							if (result.isConfirmed) {
								window.location.href = "<?= base_url('signup') ?>";
							}
						});
					}
				});
			return false;
		}
		*/
	</script>