<?php get_codes('header', $meta_array); ?>
<!-- Google tag (gtag.js) -->

<!-- Cursor follower -->


<style>
	@media screen and (max-width:576px) {
		.header-logo {
			max-width: 36% !important;
			height: auto;
			display: block;
		}

		.img-fluid {
			max-width: 55%;
			height: auto;
		}

		@media screen and (max-width: 576px) {
			.offcanvas__wrapper .offcanvas__content .offcanvas__close {
				width: 36px;
				height: 36px;
				line-height: 39px;
				text-align: center;
				border-radius: 50%;
				background-color: var(--theme);
				position: relative;
				z-index: 1;
				cursor: pointer;
			}
		}

		.logo img {
			max-width: 247% !important;
			height: auto;
			display: block;
		}



	}

	.back-to-top {
		background: linear-gradient(#23216A, #146EB3)
	}

	.theshadows {
		display: none !important;
	}

	.logo img {
		max-width: 100%;
		height: auto;
		display: block;
	}

	.logo {
		max-width: 160px;
		/* adjust size limit for desktop */
	}

	@media (max-width: 768px) {
		.logo {
			max-width: 150px;
			/* smaller logo for tablets */
		}
	}

	@media (max-width: 480px) {
		.logo {
			max-width: 120px;
			/* smaller logo for mobiles */
		}
	}

	/* Hide by default */
	.mobile-only {
		display: none !important;
		/* Important to override other styles */
	}

	/* Show only on mobile (adjust breakpoint as needed) */
	@media (max-width: 992px) {
		.mobile-only {
			display: block !important;
		}
	}

	.cart-icon::before {

		background-color: none;
		color: none;

	}

	/* Search Suggestions Styles - Modern & Attractive */
	.search-widget {
		position: relative;
	}

	.search-suggestions {
		position: absolute;
		top: 100%;
		left: 0;
		right: 0;
		background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
		border: 2px solid #e3f2fd;
		border-radius: 16px;
		box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1), 0 8px 16px rgba(0, 0, 0, 0.06);
		z-index: 1000;
		max-height: 450px;
		overflow-y: auto;
		margin-top: 8px;
		backdrop-filter: blur(10px);
		animation: slideDown 0.3s ease-out;
	}

	@keyframes slideDown {
		from {
			opacity: 0;
			transform: translateY(-10px);
		}
		to {
			opacity: 1;
			transform: translateY(0);
		}
	}

	.search-suggestion-item {
		border-bottom: 1px solid rgba(0, 0, 0, 0.05);
		transition: all 0.3s ease;
	}

	.search-suggestion-item:last-child {
		border-bottom: none;
		border-radius: 0 0 14px 14px;
	}

	.search-suggestion-item:first-child {
		border-radius: 14px 14px 0 0;
	}

	.search-suggestion-link {
		display: block;
		padding: 16px 20px;
		text-decoration: none;
		color: inherit;
		transition: all 0.3s ease;
		position: relative;
		overflow: hidden;
	}

	.search-suggestion-link::before {
		content: '';
		position: absolute;
		top: 0;
		left: -100%;
		width: 100%;
		height: 100%;
		background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.4), transparent);
		transition: left 0.5s;
	}

	.search-suggestion-link:hover::before {
		left: 100%;
	}

	.search-suggestion-link:hover {
		background: linear-gradient(135deg, #e3f2fd 0%, #f3e5f5 100%);
		text-decoration: none;
		color: inherit;
		transform: translateX(5px);
		box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
	}

	.search-suggestion-content {
		display: flex;
		align-items: center;
		gap: 16px;
		position: relative;
		z-index: 1;
	}

	.search-suggestion-image {
		flex-shrink: 0;
		position: relative;
	}

	.search-suggestion-image img {
		border-radius: 8px;
		box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
		transition: transform 0.3s ease;
	}

	.search-suggestion-link:hover .search-suggestion-image img {
		transform: scale(1.05);
	}

	.search-suggestion-text {
		flex: 1;
		min-width: 0;
	}

	.search-suggestion-text h6 {
		margin: 0 0 4px 0;
		font-size: 15px;
		font-weight: 700;
		color: #2c3e50;
		line-height: 1.3;
		transition: color 0.3s ease;
	}

	.search-suggestion-link:hover .search-suggestion-text h6 {
		color: #0391DD;
	}

	.search-suggestion-text p {
		margin: 0 0 6px 0;
		font-size: 13px;
		color: #7f8c8d;
		font-weight: 500;
	}

	.search-suggestion-text span {
		font-size: 14px;
		font-weight: 700;
		color: #27ae60;
		background: linear-gradient(135deg, #27ae60, #2ecc71);
		-webkit-background-clip: text;
		-webkit-text-fill-color: transparent;
		background-clip: text;
	}

	/* Loading Animation */
	.search-suggestion-item.loading {
		text-align: center;
		padding: 20px;
		color: #7f8c8d;
		font-style: italic;
	}

	.search-suggestion-item.loading::after {
		content: '';
		display: inline-block;
		width: 20px;
		height: 20px;
		border: 2px solid #e0e0e0;
		border-radius: 50%;
		border-top-color: #0391DD;
		animation: spin 1s ease-in-out infinite;
		margin-left: 10px;
	}

	@keyframes spin {
		to { transform: rotate(360deg); }
	}

	/* Error State */
	.search-suggestion-item.error {
		text-align: center;
		padding: 20px;
		color: #e74c3c;
		background: linear-gradient(135deg, #ffebee 0%, #fce4ec 100%);
		border-left: 4px solid #e74c3c;
	}

	/* No Results State */
	.search-suggestion-item.no-results {
		text-align: center;
		padding: 20px;
		color: #7f8c8d;
		background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
	}

	/* Scrollbar Styling */
	.search-suggestions::-webkit-scrollbar {
		width: 6px;
	}

	.search-suggestions::-webkit-scrollbar-track {
		background: #f1f1f1;
		border-radius: 3px;
	}

	.search-suggestions::-webkit-scrollbar-thumb {
		background: linear-gradient(135deg, #0391DD, #7CD1F9);
		border-radius: 3px;
	}

	.search-suggestions::-webkit-scrollbar-thumb:hover {
		background: linear-gradient(135deg, #0277bd, #0391DD);
	}

	.header-icon {
		list-style: none;
		padding: 0;
		margin: 0;
		display: flex;
		align-items: center;
	}

	.header-icon li {
		position: relative;
		margin-right: 15px;
	}

	.header-icon li a {
		display: inline-block;
		position: relative;
		text-decoration: none;
		color: inherit;
	}

	/* Make badge visible on all screens */
	.header-icon li a .number {
		position: absolute;
		top: -6px;
		right: -10px;
		font-size: 0.7rem;
		padding: 2px 5px;
		border-radius: 50%;
		background-color: #dc3545;
		/* red badge */
		color: #fff;
		display: inline-block;
		min-width: 18px;
		text-align: center;
	}

	.header-icon li a i {
		font-size: 1.3rem;
	}

	/* Force visibility on mobile */
	.header-icon {
		display: flex !important;
	}

	.header-icon li {
		display: inline-block !important;
	}

	/* Navigation Menu Alignment Fix - Only Layout, No Style Changes */
	.main-menu nav ul {
		display: flex !important;
		flex-wrap: nowrap !important;
		align-items: center !important;
		justify-content: flex-start !important;
		gap: 20px !important;
		margin: 0 !important;
		padding: 0 !important;
		list-style: none !important;
	}

	.main-menu nav ul li {
		white-space: nowrap !important;
		flex-shrink: 0 !important;
		margin: 0 !important;
		padding: 0 !important;
		position: relative;
	}

	/* Bootstrap Dropdown Styles for Categories */
	.main-menu nav ul li.dropdown {
		position: relative;
	}

	.main-menu nav ul li.dropdown .dropdown-toggle {
		cursor: pointer;
		display: flex;
		align-items: center;
		text-decoration: none;
	}


	.main-menu nav ul li.dropdown {
		position: relative;
	}

	.main-menu nav ul li.dropdown .dropdown-menu {
		position: absolute;
		top: 100%;
		left: 0;
		z-index: 1000;
		display: none !important;
		flex-direction: column !important;
		min-width: 200px;
		max-width: 250px;
		/* Removed max-height and overflow-y to show all items without scroll */
		overflow-x: visible !important;
		overflow: visible !important;
		/* Allow sub-submenu to overflow */
		clip: unset !important;
		clip-path: none !important;
		padding: 0.5rem 0;
		margin: 0;
		margin-top: 5px;
		font-size: 1rem;
		color: #212529;
		text-align: left;
		list-style: none;
		background-color: #fff;
		background-clip: padding-box;
		border: 1px solid rgba(0, 0, 0, 0.15);
		border-radius: 0;
		box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
		opacity: 0;
		visibility: hidden;
		transform: translateY(-10px);
		transition: opacity 0.2s ease, transform 0.2s ease, visibility 0.2s ease;
	}

	.main-menu nav ul li.dropdown.show .dropdown-menu {
		display: block !important;
		opacity: 1;
		visibility: visible;
		transform: translateY(0);
	}

	.main-menu nav ul li.dropdown.show .dropdown-menu.scrollable-dropdown {
		display: block !important;
		opacity: 1;
		visibility: visible;
		transform: translateY(0);
		/* Removed max-height and overflow-y to show all items */
		overflow-x: visible !important;
	}

	.main-menu nav ul li.dropdown .dropdown-menu li {
		list-style: none;
		margin: 0;
		padding: 0;
		display: block !important;
		width: 100% !important;
		float: none !important;
		clear: both;
	}

	.main-menu nav ul li.dropdown .dropdown-item {
		display: block !important;
		width: 100% !important;
		padding: 0.5rem 1rem;
		clear: both;
		font-weight: 400;
		color: #212529;
		text-align: left;
		text-decoration: none;
		white-space: nowrap;
		background-color: transparent;
		border: 0;
		transition: all 0.2s ease;
		line-height: 1.5;
		box-sizing: border-box;
	}

	.main-menu nav ul li.dropdown .dropdown-item:hover,
	.main-menu nav ul li.dropdown .dropdown-item:focus {
		color: #1e2125;
		background-color: #e9ecef;
		text-decoration: none;
	}

	/* Dropdown - Show all items, no scroll limit */
	.main-menu nav ul li.dropdown .dropdown-menu.scrollable-dropdown {
		height: auto !important;
		overflow-x: visible !important;
		display: block !important;
		position: absolute !important;
	}

	/* All dropdowns - Show all items, no scroll */
	.main-menu nav ul li.dropdown .dropdown-menu {
		overflow-x: visible !important;
	}

	/* Webkit Scrollbar Styling (Chrome, Safari, Edge) - For all dropdowns */
	.main-menu nav ul li.dropdown .dropdown-menu::-webkit-scrollbar {
		width: 8px !important;
		display: block !important;
	}

	.main-menu nav ul li.dropdown .dropdown-menu::-webkit-scrollbar-track {
		background: #f1f1f1 !important;
		border-radius: 4px;
	}

	.main-menu nav ul li.dropdown .dropdown-menu::-webkit-scrollbar-thumb {
		background: #888 !important;
		border-radius: 4px;
	}

	.main-menu nav ul li.dropdown .dropdown-menu::-webkit-scrollbar-thumb:hover {
		background: #555 !important;
	}

	/* Sub-submenu - Same pattern as main dropdown */
	.main-menu nav ul li.dropdown .dropdown-submenu {
		position: relative;
	}
	
	.main-menu nav ul li.dropdown .dropdown-submenu .sub-submenu {
		position: absolute !important;
		top: 0 !important;
		left: 100% !important;
		margin-left: 5px !important;
		min-width: 200px !important;
		max-width: 250px !important;
		/* Removed max-height and overflow-y to show all items without scroll */
		overflow-x: visible !important;
		display: none !important;
		opacity: 0 !important;
		visibility: hidden !important;
		transform: translateX(-10px) !important;
		transition: opacity 0.2s ease, transform 0.2s ease, visibility 0.2s ease !important;
		z-index: 1001 !important;
		background-color: #fff !important;
		border: 1px solid rgba(0, 0, 0, 0.15) !important;
		box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15) !important;
		padding: 0.5rem 0 !important;
		list-style: none !important;
	}
	
	/* Show sub-submenu when parent has .show class - Same as main dropdown */
	.main-menu nav ul li.dropdown .dropdown-submenu.show .sub-submenu,
	.main-menu nav ul li.dropdown .dropdown-submenu.show ul.sub-submenu,
	.main-menu nav ul li.dropdown .dropdown-submenu.show .dropdown-menu.sub-submenu {
		display: block !important;
		opacity: 1 !important;
		visibility: visible !important;
		transform: translateX(0) !important;
	}

	/* Arrow styling for submenu items */
	.main-menu nav ul li.dropdown .dropdown-item span {
		font-size: 12px;
		color: #666;
	}

	/* Prevent link navigation if submenu exists */
	.main-menu nav ul li.dropdown .dropdown-item.has-submenu {
		cursor: pointer;
	}

	/* Ensure proper spacing for header elements */
	.header-main {
		display: flex !important;
		align-items: center !important;
		justify-content: space-between !important;
		width: 100% !important;
	}

	.mean__menu-wrapper {
		flex: 1 !important;
		margin: 0 20px !important;
	}

	.header-right {
		flex-shrink: 0 !important;
		display: flex !important;
		align-items: center !important;
		gap: 15px !important;
	}

	/* Responsive adjustments */
	@media (max-width: 1200px) {
		.main-menu nav ul {
			gap: 15px !important;
		}
	}

	@media (max-width: 992px) {
		.mean__menu-wrapper {
			display: none !important;
		}
	}

	/* Header Top Content Alignment */
	.header-top-wrapper .content {
		display: flex !important;
		align-items: center !important;
		gap: 15px !important;
	}

	/* Language Dropdown Styles */
	.language-dropdown {
		position: relative;
		margin-right: 15px;
		display: block !important;
	}

	.language-dropdown,
	.language-dropdown * {
		-webkit-user-select: none;
		user-select: none;
	}

	.language-dropdown.notranslate,
	.language-dropdown .notranslate {
		unicode-bidi: isolate;
	}

	.language-dropdown .lang-toggle {
		background: #fff;
		border: 1px solid #ddd;
		border-radius: 6px;
		padding: 4px 10px;
		height: 30px;
		line-height: 20px;
		cursor: pointer;
		font-size: 14px;
		color: #333;
		transition: all 0.3s ease;
		white-space: nowrap;
	}

	.language-dropdown .lang-toggle:hover {
		background: #f5f5f5;
		border-color: #bbb;
	}

	.language-dropdown .chev {
		font-size: 12px;
		margin-left: 6px;
		color: #666;
	}

	.language-dropdown .lang-dropdown-box {
		position: absolute;
		top: calc(100% + 6px);
		right: 0;
		display: none !important;
		background: #fff;
		min-width: 150px;
		border: 1px solid #e5e5e5;
		border-radius: 8px;
		box-shadow: 0 8px 24px rgba(0, 0, 0, .12);
		padding: 6px;
		z-index: 9999;
		max-height: 200px;
		overflow-y: auto;
		-webkit-overflow-scrolling: touch;
		overscroll-behavior: contain;
	}

	/* Mobile Language Dropdown (in main header) */
	.language-dropdown-mobile {
		position: relative;
		margin-right: 10px;
	}

	.language-dropdown-mobile .lang-toggle {
		background: #fff;
		border: 1px solid #ddd;
		border-radius: 6px;
		padding: 4px 8px;
		height: 32px;
		line-height: 22px;
		cursor: pointer;
		font-size: 13px;
		color: #333;
		transition: all 0.3s ease;
		white-space: nowrap;
	}

	.language-dropdown-mobile .lang-toggle:hover {
		background: #f5f5f5;
		border-color: #bbb;
	}

	.language-dropdown-mobile .lang-dropdown-box {
		position: absolute;
		top: calc(100% + 6px);
		right: 0;
		display: none !important;
		background: #fff;
		min-width: 130px;
		border: 1px solid #e5e5e5;
		border-radius: 8px;
		box-shadow: 0 8px 24px rgba(0, 0, 0, .12);
		padding: 6px;
		z-index: 9999;
		max-height: 200px;
		overflow-y: auto;
	}

	.language-dropdown-mobile.open .lang-dropdown-box {
		display: block !important;
	}

	.language-dropdown-mobile .lang-dropdown-box a {
		display: block;
		padding: 8px 10px;
		border-radius: 6px;
		color: #333;
		text-decoration: none;
		font-size: 13px;
		transition: all 0.2s ease;
	}

	.language-dropdown-mobile .lang-dropdown-box a:hover {
		background: #f5f5f5;
	}

	.language-dropdown-mobile .lang-dropdown-box a.active {
		background: #eef3ff;
		font-weight: 600;
		color: #0391DD;
	}

	/* Override header-top-section hidden on mobile to show language converter */
	@media (max-width: 1399px) {
		.header-top-section {
			display: none !important;
		}
	}

	/* Mobile Responsive Styles */
	@media (max-width: 767px) {
		.language-dropdown {
			margin-right: 10px;
		}

		.language-dropdown .lang-toggle {
			padding: 4px 8px;
			font-size: 13px;
			height: 28px;
			line-height: 18px;
		}

		.language-dropdown .lang-dropdown-box {
			min-width: 130px;
			right: 0;
		}

		.header-top-wrapper .content {
			flex-wrap: wrap;
			gap: 10px !important;
		}

		.language-dropdown-mobile {
			margin-right: 8px;
		}

		.language-dropdown-mobile .lang-toggle {
			padding: 4px 6px;
			font-size: 12px;
			height: 30px;
		}
	}

	@media (max-width: 575px) {
		.language-dropdown {
			margin-right: 8px;
		}

		.language-dropdown .lang-toggle {
			padding: 3px 6px;
			font-size: 12px;
			height: 26px;
			line-height: 18px;
		}

		.language-dropdown .current-label {
			font-size: 12px;
		}

		.language-dropdown .lang-dropdown-box {
			min-width: 120px;
		}

		.language-dropdown-mobile .lang-toggle {
			padding: 3px 5px;
			font-size: 11px;
			height: 28px;
		}

		.language-dropdown-mobile .current-label {
			font-size: 11px;
		}
	}

	.language-dropdown .lang-dropdown-box::-webkit-scrollbar {
		width: 8px;
	}

	.language-dropdown .lang-dropdown-box::-webkit-scrollbar-thumb {
		background: #ddd;
		border-radius: 6px;
	}

	.language-dropdown.open .lang-dropdown-box {
		display: block !important;
	}

	.language-dropdown .lang-dropdown-box a {
		display: block;
		padding: 8px 10px;
		border-radius: 6px;
		color: #333;
		text-decoration: none;
		font-size: 14px;
		transition: all 0.2s ease;
	}

	.language-dropdown .lang-dropdown-box a:hover {
		background: #f5f5f5;
	}

	.language-dropdown .lang-dropdown-box a.active {
		background: #eef3ff;
		font-weight: 600;
		color: #0391DD;
	}

	/* Hide Google branding and banner */
	.goog-logo-link,
	.goog-te-gadget span,
	.goog-te-gadget-icon,
	.goog-te-banner-frame.skiptranslate {
		display: none !important;
	}

	body {
		top: 0 !important;
	}
</style>

<!-- Back To Top start -->
<button id="back-top" class="back-to-top">
	<i class="fa-solid fa-chevron-up"></i>
</button>

<!-- Offcanvas Area start  -->
<div class="fix-area">
	<div class="offcanvas__info">
		<div class="offcanvas__wrapper">
			<div class="offcanvas__content">
				<div class="offcanvas__top mb-5 d-flex justify-content-between align-items-center">
					<div class="offcanvas__logo">
						<a href="<?= base_url('') ?>">
							<img src="<?= base_url('assets/avator/logo_light.png') ?>" alt="logo-img" class="img-fluid logo-img" style="width:180px; height:auto;">
						</a>
					</div>
					<div class="offcanvas__close">
						<button>
							<i class="fas fa-times"></i>
						</button>
					</div>
				</div>
				<p class="text d-none d-xl-block">
					Explore a world of knowledge and imagination at our bookstore. Discover the latest bestsellers, timeless classics, and hidden gems that inspire and entertain readers of all ages.
				</p>
				<div class="mobile-menu fix mb-3"></div>
				<div class="offcanvas__contact">
					<h4>Contact Info</h4>
					<ul>
						<li class="d-flex align-items-center">
							<div class="offcanvas__contact-icon">
								<i class="fal fa-map-marker-alt"></i>
							</div>
							<div class="offcanvas__contact-text">
								<a target="_blank" href="#"><?= $site_address ?></a>
							</div>
						</li>
						<li class="d-flex align-items-center">
							<div class="offcanvas__contact-icon mr-15">
								<i class="fal fa-envelope"></i>
							</div>
							<div class="offcanvas__contact-text">
								<a href="mailto:info@example.com"><span
										class="#"><?= $site_email ?></span></a>
							</div>
						</li>
						<!-- <li class="d-flex align-items-center">
							<div class="offcanvas__contact-icon mr-15">
								<i class="fal fa-clock"></i>
							</div>

						</li> -->
						<li class="d-flex align-items-center">
							<div class="offcanvas__contact-icon mr-15">
								<i class="far fa-phone"></i>
							</div>
							<div class="offcanvas__contact-text">
								<a href="#"><?= $site_phone ?></a>
							</div>
						</li>
					</ul>
					<div class="header-button mt-4">
						<a href="<?= base_url('contact') ?>" class="theme-btn text-center">
							Get In Touch<i class="fa-solid fa-arrow-right-long"></i>
						</a>
					</div>
					<div class="social-icon d-flex align-items-center">
						<a href="<?= $social_fb ?>"><i class="fab fa-facebook-f"></i></a>
						<a href="<?= $social_tw ?>"><i class="fab fa-twitter"></i></a>
						<a href="<?= $social_yt ?>"><i class="fab fa-youtube"></i></a>
						<a href="<?= $social_in ?>"><i class="fab fa-instagram"></i></a>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<div class="offcanvas__overlay"></div>


<!-- Header Top section start -->
<div class="header-top-section first">
	<div class="container-fluid">
		<div class="header-top-wrapper">
			<ul class="contact-list">
				<li>
					<a href="<?= $social_fb ?>">
						<i class="fa-brands fa-facebook-f">

						</i> 7500k followers</a>

				</li>
				<li>
					<i class="fa-solid fa-phone"></i>
					<a href="#"><?= $site_phone ?></a>
				</li>
			</ul>


			<div class="content">
				<!-- Language Dropdown (English and Hindi only) -->
				<div class="language-dropdown notranslate" translate="no">
					<button type="button" class="lang-toggle notranslate" translate="no"><span class="current-label notranslate" translate="no">Language</span> <span class="chev">▾</span></button>
					<div class="lang-dropdown-box notranslate" translate="no">
						<a href="#" class="notranslate" translate="no" data-lang="en">English</a>
						<a href="#" class="notranslate" translate="no" data-lang="hi">हिंदी</a>
					</div>
				</div>
				<!-- Hidden Google gadget used for translation control -->
				<div id="google_translate_element_header" style="display:none"></div>

				<?php if ($this->session->userdata('yid')): ?>
					<a href="<?= base_url('index.php/main/profile') ?>" class="account-text d-flex align-items-center gap-2">
						<i class="fa-regular fa-user"></i>
						<?= ucwords($this->session->userdata('name')) ?>
					</a>
				<?php else: ?>

					<button class="account-text d-flex align-items-center gap-2">
						<i class="fa-regular fa-user"></i>
						<a href="<?= base_url('login') ?>">Log in</a>
					</button>
				<?php endif; ?>


			</div>
		</div>
	</div>
</div>

<!-- Header Section Start -->
<header id="header-sticky" class="header-1 second">
	<div class="container-fluid">
		<div class="mega-menu-wrapper">
			<div class="header-main">
				<div class="logo">
					<a href="<?= base_url('') ?>" class="header-logo">
						<img src="<?= base_url('assets/avator/logo_light.png') ?>" alt="logo-img" class="img-fluid logo-img" style="width:100px; height:auto;">
					</a>
					<a href="<?= base_url('') ?>" class="header-logo-2 d-none">
						<img src="<?= base_url('assets/avator/logo_light.png') ?>" alt="logo-img" class="img-fluid logo-img" style="width:100px; height:auto;">
					</a>
				</div>

				<div class="mean__menu-wrapper">
					<div class="main-menu">
						<nav id="mobile-menu" style="display: block;">
							<ul>
								
								<?php
								// First 5 categories - Show dropdowns only if they have subcategories
								$categories = $this->db->query("SELECT * FROM yn_site_catagory ORDER BY sid ASC LIMIT 5")->result_array();
								
								if (!empty($categories)):
									foreach ($categories as $index => $cat): 
										// Check if category has subcategories from yn_site_sub_cat table
										$ctid_escaped = (int)$cat['ctid'];
										$subcategories = $this->db->query("SELECT * FROM yn_site_sub_cat WHERE sc_ctid = '$ctid_escaped' ORDER BY sc_sort ASC")->result_array();
										
										// If has subcategories, show dropdown
										if (!empty($subcategories)): ?>
											<li class="menu-item dropdown">
												<a href="<?= base_url('shop?cate=' . $cat['ctid']) ?>" 
												   class="item-link dropdown-toggle" 
												   role="button">
													<?= htmlspecialchars($cat['name']) ?>
												</a>
												<ul class="dropdown-menu">
													<li>
														<a class="dropdown-item" href="<?= base_url('shop?cate=' . $cat['ctid']) ?>">
															View All <?= htmlspecialchars($cat['name']) ?>
														</a>
													</li>
													<?php foreach ($subcategories as $subcat): 
														// Check if subcategory has sub-subcategories from yn_site_sub2_cat table
														$sc_id_escaped = (int)$subcat['sc_id'];
														$sub_subcategories = $this->db->query("SELECT * FROM yn_site_sub2_cat WHERE mr_sub2_sid = '$sc_id_escaped' ORDER BY mr_sub2_sort ASC")->result_array();
													?>
														<li class="<?= !empty($sub_subcategories) ? 'dropdown-submenu' : '' ?>" 
															<?php if (!empty($sub_subcategories)): ?>data-submenu-id="submenu-<?= $subcat['sc_id'] ?>"<?php endif; ?>>
															<a class="dropdown-item <?= !empty($sub_subcategories) ? 'has-submenu' : '' ?>" 
															   href="<?= !empty($sub_subcategories) ? 'javascript:void(0);' : base_url('shop?subcate=' . $subcat['sc_id']) ?>">
																<?= htmlspecialchars($subcat['sc_name']) ?>
																<?php if (!empty($sub_subcategories)): ?>
																	<span class="submenu-toggle" style="float: right; margin-left: 10px; cursor: pointer;">▶</span>
																<?php endif; ?>
															</a>
															<?php if (!empty($sub_subcategories)): ?>
																<ul class="dropdown-menu sub-submenu" id="submenu-<?= $subcat['sc_id'] ?>">
																	<?php foreach ($sub_subcategories as $sub_subcat): ?>
																		<li>
																			<a class="dropdown-item" href="<?= base_url('shop?subcate=' . $sub_subcat['mr_sub2_id']) ?>">
																				<?= htmlspecialchars($sub_subcat['mr_sub2_name']) ?>
																			</a>
																		</li>
																	<?php endforeach; ?>
																</ul>
															<?php endif; ?>
														</li>
													<?php endforeach; ?>
												</ul>
											</li>
										<?php else: ?>
											<!-- No subcategories - simple link -->
											<li class="menu-item">
												<a href="<?= base_url('shop?cate=' . $cat['ctid']) ?>" class="item-link">
													<?= htmlspecialchars($cat['name']) ?>
												</a>
											</li>
										<?php endif;
									endforeach;
								endif; ?>
								
								<!-- Static Links - Study Material and Mock Tests -->
								<li class="menu-item">
									<a href="<?= base_url('search') ?>" class="item-link">Study Material</a>
								</li>
								<li class="menu-item">
									<a href="<?= base_url('Mock_test_categories') ?>" class="item-link">Mock Tests</a>
								</li>

								<li class="mobile-only">
									<?php if (isset($_SESSION['yid']) && $_SESSION['yid'] != ''): ?>
										<a href="<?= base_url('index.php/main/profile') ?>" class="tf-btn type-small style-2">
											<?= $_SESSION['username'] ?? 'My Profile' ?>
											<i class="icon icon-user"></i>
										</a>
										<a href="<?= base_url('logout') ?>" class="tf-btn type-small style-2">
											Logout
											<i class="icon icon-user"></i>
										</a>
									<?php else: ?>
										<a href="<?= base_url('login') ?>" class="tf-btn type-small style-2">
											Login
											<i class="icon icon-user"></i>
										</a>
									<?php endif; ?>
								</li>

							</ul>
						</nav>
					</div>
				</div>

				<div class="header-right d-flex justify-content-end align-items-center">
					<div class="search-widget">
						<form action="<?= base_url('shop') ?>" id="searchForm">
							<input type="text" placeholder="Search for Products..." name="q" id="searchInput" autocomplete="off">
							<button type="submit"><i class="fa-solid fa-magnifying-glass"></i></button>
						</form>
						<div id="searchSuggestions" class="search-suggestions" style="display: none;">
							<div id="suggestionsContent"></div>
						</div>
					</div>
					<a href="#0" class="search-trigger search-icon style-2"></a>
					<!-- Header Wishlist Icon -->
					<?php
					$wishlist_count = 0;
					if (isset($_SESSION['yid'])) {
						$wishlist_count = $this->db->query("SELECT COUNT(*) as total FROM wishlist WHERE user_id=?", [$_SESSION['yid']])->row()->total;
					}
					?>
					<ul class="header-icon">
						<li>
							<a href="javascript:void(0);" class="wishlist-trigger">
								<i class="fa-regular fa-heart"></i>
								<span class="number" id="wishlist-count"><?= $wishlist_count ?></span>
							</a>
						</li>
					</ul>

					<!-- Wishlist Modal -->
					<div id="wishlist-modal" class="wishlist-modal">
						<div class="wishlist-content">
							<div class="wishlist-header">
								<h4 style="color: white;"> Your Wishlist</h4>
								<span class="wishlist-close">&times;</span>
							</div>
							<div class="wishlist-body" id="wishlist-items">
								<p class="text-center">Loading...</p>
							</div>

						</div>
					</div>
					<style>
						/* Modal Background */
						.wishlist-modal {
							display: none;
							position: fixed;
							z-index: 9999;
							left: 0;
							top: 0;
							width: 100%;
							height: 100%;
							background: rgba(0, 0, 0, 0.6);
							transition: all 0.3s ease;
						}

						/* Modal Content */
						.wishlist-content {
							background: #fff;
							width: 450px;
							max-width: 95%;
							margin: 80px auto;
							border-radius: 12px;
							overflow: hidden;
							box-shadow: 0 8px 30px rgba(0, 0, 0, 0.2);
							display: flex;
							flex-direction: column;
						}

						/* Header */
						.wishlist-header {
							padding: 15px 20px;
							border-bottom: 1px solid #eee;
							display: flex;
							justify-content: space-between;
							align-items: center;
							background: #0B8CD4;
							color: white !important;
							font-weight: 600;
							font-size: 1.1rem;
						}

						.wishlist-close {
							cursor: pointer;
							font-size: 24px;
							font-weight: bold;
						}

						/* Body */
						.wishlist-body {
							max-height: 400px;
							overflow-y: auto;
							padding: 15px;
							display: flex;
							flex-direction: column;
							gap: 10px;
						}

						/* Wishlist Items */
						.wishlist-item {
							display: flex;
							justify-content: space-between;
							align-items: center;
							padding: 10px;
							border-radius: 8px;
							box-shadow: 0 2px 6px rgba(0, 0, 0, 0.05);
							transition: all 0.2s ease;
							background: #fff;
						}

						.wishlist-item:hover {
							transform: translateY(-2px);
							box-shadow: 0 6px 12px rgba(0, 0, 0, 0.1);
						}

						.wishlist-item img {
							width: 60px;
							height: 70px;
							object-fit: cover;
							border-radius: 6px;
							margin-right: 12px;
						}

						.wishlist-item .item-info {
							flex: 1;
						}

						.wishlist-item .item-info h5 {
							margin: 0;
							font-size: 0.95rem;
							color: #333;
							font-weight: 600;
						}

						.wishlist-item .item-info span {
							display: block;
							font-size: 0.85rem;
							color: #777;
						}

						.wishlist-item .remove-btn {
							cursor: pointer;
							color: #ff4b4b;
							font-size: 18px;
							transition: color 0.2s;
						}

						.wishlist-item .remove-btn:hover {
							color: #e60000;
						}

						/* Footer */
						.wishlist-footer {
							padding: 12px 20px;
							border-top: 1px solid #eee;
							background: #fafafa;
						}

						.view-all-btn {
							display: inline-block;
							padding: 8px 18px;
							background: #ff7b6b;
							color: #fff;
							border-radius: 25px;
							font-weight: 600;
							text-decoration: none;
							transition: all 0.2s ease;
						}

						.view-all-btn:hover {
							background: #0B8CD4;
						}

						/* Responsive */
						@media(max-width: 576px) {
							.wishlist-content {
								width: 95%;
								margin: 50px auto;
							}

							.wishlist-item img {
								width: 50px;
								height: 60px;
							}

							.wishlist-header {
								font-size: 1rem;
							}
						}
					</style>

					<script>
						$(document).ready(function() {
							// Open modal
							$('.wishlist-trigger').click(function() {
								$('#wishlist-modal').fadeIn();
								loadWishlist();
							});

							// Close modal
							$('.wishlist-close').click(function() {
								$('#wishlist-modal').fadeOut();
							});

							// Load wishlist items via AJAX
							function loadWishlist() {
								$.ajax({
									url: "<?= base_url('index.php/action/get_wishlist') ?>",
									type: "GET",
									dataType: "json",
									success: function(res) {
										let html = '';
										if (res.items && res.items.length > 0) {
											res.items.forEach(item => {
												html += `
                        <div class="wishlist-item" data-id="${item.p_id}">
                            <img src="<?= base_url('assets/avator/upload/') ?>${item.p_cover}" alt="${item.p_name}">
                            <div class="item-info">
                                <h5>${item.p_name}</h5>
                               
                            </div>
                            <span class="remove-btn" data-id="${item.p_id}">&times;</span>
                        </div>
                        `;
											});
										} else {
											html = '<p class="text-center">Your wishlist is empty.</p>';
										}
										$('#wishlist-items').html(html);
										$('#wishlist-count').text(res.count);
									},
									error: function() {
										$('#wishlist-items').html('<p class="text-center">Failed to load wishlist.</p>');
									}
								});
							}

							// Remove item from wishlist
							$(document).on('click', '.wishlist-item .remove-btn', function() {
								let product_id = $(this).data('id');
								$.ajax({
									url: "<?= base_url('index.php/action/wishlist_toggle') ?>",
									type: "POST",
									data: {
										product_id: product_id
									},
									dataType: "json",
									success: function(res) {
										loadWishlist();
									},
									error: function() {
										alert('Failed to remove item.');
									}
								});
							});
						});
					</script>





					<!-- Wishlist Modal -->



					<div class="menu-cart">
						<div class="cart-box">
							<ul id="nav-cart-items">
								<?php if (!empty($_SESSION['ecom_cart'])): ?>
									<?php foreach ($_SESSION['ecom_cart'] as $index => $item): ?>
										<li data-index="<?= $index ?>">
											<img src="<?= base_url('assets/avator/upload/') . $item['p_img'] ?>" alt="image">
											<div class="cart-product">
												<div class="cart-ctx">
													<a href="#"><?= $item['p_name'] ?></a>
													<span>₹<?= $item['p_price'] ?></span>
												</div>
												<i class="fa-solid fa-xmark remove-cart-item" style="cursor:pointer;"></i>
											</div>
										</li>
									<?php endforeach; ?>
								<?php else: ?>
									<li>No items in cart</li>
								<?php endif; ?>
							</ul>

							<div class="shopping-items">
								<span>Total :</span>
								<?php
								$total = !empty($_SESSION['ecom_cart']) ? getCartAmount_row() : 0;
								?>
								<span id="cart-total"><?= '₹' . number_format($total, 2) ?></span>

							</div>

							<div class="cart-button mb-4">
								<a href="<?= base_url('cart') ?>" class="theme-btn">View Cart</a>
							</div>
						</div>

						<a href="<?= base_url('cart') ?>" class="cart-icon position-relative">
							<i class="fa-sharp fa-regular fa-bag-shopping"></i>
							<?php
							if (isset($_SESSION['ecom_cart']) && is_array($_SESSION['ecom_cart']) && count($_SESSION['ecom_cart']) > 0):
							?>
								<span id="nav-cart-count" class="cart-badge badge position-absolute"
									style="top: -10px; right: -8px; font-size: 0.7rem; padding: 3px 6px; border-radius: 50%; background-color:#0B8CD4;">
									<?= count($_SESSION['ecom_cart']) ?>
								</span>
							<?php endif; ?>
						</a>


					</div>
					<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
					<script>
						document.addEventListener('DOMContentLoaded', function() {
							// Function to remove item from cart
							function removeCartItem(index, liElement) {
								fetch('<?= base_url("index.php/action/remove_item") ?>', {
										method: 'POST',
										headers: {
											'Content-Type': 'application/json'
										},
										body: JSON.stringify({
											index: index
										})
									})
									.then(res => res.json())
									.then(data => {
										if (data.success) {
											// Remove item from DOM
											liElement.remove();

											// Update total
											document.getElementById('cart-total').innerText = '₹' + parseFloat(data.total).toFixed(2);

											// Update cart badge count
											const badge = document.getElementById('nav-cart-count');
											if (data.count > 0) {
												badge.innerText = data.count;
											} else {
												badge.remove();
												document.getElementById('nav-cart-items').innerHTML = '<li>No items in cart</li>';
											}

											// SweetAlert success notification
											Swal.fire({
												icon: 'success',
												title: 'Removed!',
												text: 'Item has been removed from your cart.',
												confirmButtonColor: '#7CD1F9'
											});
										} else {
											// SweetAlert error notification
											Swal.fire({
												icon: 'error',
												title: 'Oops!',
												text: 'Unable to remove item.',
												confirmButtonColor: '#7CD1F9'
											});
										}
									});
							}

							// Attach click event to all remove buttons
							document.querySelectorAll('.remove-cart-item').forEach(btn => {
								btn.addEventListener('click', function() {
									const li = this.closest('li');
									const index = li.getAttribute('data-index');

									// Confirmation before removal
									Swal.fire({
										title: 'Are you sure?',
										text: "Do you want to remove this item from the cart?",
										icon: 'warning',
										showCancelButton: true,
										confirmButtonColor: '#7CD1F9',
										cancelButtonColor: '#d33',
										confirmButtonText: 'Yes, remove it!',
										cancelButtonText: 'Cancel'
									}).then((result) => {
										if (result.isConfirmed) {
											removeCartItem(index, li);
										}
									});
								});
							});
						});
					</script>


					<!-- Language Dropdown for Mobile (visible only when header-top-section is hidden) -->
					<div class="language-dropdown-mobile notranslate d-block d-xl-none" translate="no">
						<button type="button" class="lang-toggle notranslate" translate="no"><span class="current-label notranslate" translate="no">Language</span> <span class="chev">▾</span></button>
						<div class="lang-dropdown-box notranslate" translate="no">
							<a href="#" class="notranslate" translate="no" data-lang="en">English</a>
							<a href="#" class="notranslate" translate="no" data-lang="hi">हिंदी</a>
						</div>
					</div>

					<div class="header__hamburger d-xl-none my-auto">
						<div class="sidebar__toggle">
							<i class="fas fa-bars"></i>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</header>

<script>
console.log('Sub-submenu: Using pure CSS hover solution');
// Test if sub-submenu elements exist
document.addEventListener('DOMContentLoaded', function() {
	var submenus = document.querySelectorAll('.sub-submenu');
	console.log('Found ' + submenus.length + ' sub-submenu elements');
	if (submenus.length > 0) {
		console.log('First sub-submenu:', submenus[0]);
		console.log('Parent element:', submenus[0].closest('.dropdown-submenu'));
	}
});
</script>
<!-- Sidebar Area -->
<div class="side_bar slideInRight side_bar_hidden">
	<div class="side_bar_overlay"></div>

	<a href="<?= base_url('login') ?>">
		<div class="cart-title mb-30">
			<h4>Log in</h4>
		</div>
	</a>





</div>
<style>
	/* Sidebar scrollable for mobile */
	#targetElement {
		max-height: 90vh;
		/* prevent overflow */
		overflow-y: auto;
		padding: 20px;
		width: 95%;
		/* almost full width on mobile */
		max-width: 400px;
		box-sizing: border-box;
	}

	/* Center captcha */
	.captcha-container {
		display: flex;
		justify-content: center;
		/* horizontal center */
		margin: 15px 0;
	}

	/* Make captcha responsive */
	.captcha-container iframe,
	.captcha-container img {
		max-width: 100%;
		height: auto;
	}

	/* Center buttons and links */
	.login-sidebar .theme-btn,
	.user-icon-box a,
	.from-cheak-items a {
		display: inline-block;
	}
</style>



<script>
	function openLoginSidebar() {
		var targetElement = document.getElementById('targetElement');
		if (targetElement) {
			targetElement.classList.remove('side_bar_hidden');
		}
	}

	// Close button
	var closeButton = document.getElementById('closeButton');
	if (closeButton) {
		closeButton.addEventListener('click', function() {
			var targetElement = document.getElementById('targetElement');
			if (targetElement) {
				targetElement.classList.add('side_bar_hidden');
			}
		});
	}

	// Click outside sidebar to close
	var sideBarOverlay = document.querySelector('.side_bar_overlay');
	if (sideBarOverlay) {
		sideBarOverlay.addEventListener('click', function() {
			var targetElement = document.getElementById('targetElement');
			if (targetElement) {
				targetElement.classList.add('side_bar_hidden');
			}
		});
	}

	// Search Suggestions Functionality
	$(document).ready(function() {
		console.log('Search functionality initialized');
		let searchTimeout;
		
		$('#searchInput').on('input', function() {
			const query = $(this).val().trim();
			console.log('Search input:', query);
			
			// Clear previous timeout
			clearTimeout(searchTimeout);
			
			if (query.length >= 1) { // Changed from 2 to 1 for testing
				// Set timeout to avoid too many requests
				searchTimeout = setTimeout(function() {
					console.log('Searching for:', query);
					searchProducts(query);
				}, 300);
			} else {
				$('#searchSuggestions').hide();
			}
		});

		// Hide suggestions when clicking outside
		$(document).on('click', function(e) {
			if (!$(e.target).closest('.search-widget').length) {
				$('#searchSuggestions').hide();
			}
		});

		// Show suggestions when clicking on search input
		$('#searchInput').on('focus', function() {
			const query = $(this).val().trim();
			console.log('Search input focused, query:', query);
			if (query.length >= 1) {
				$('#searchSuggestions').show();
			}
		});

		function searchProducts(query) {
			console.log('AJAX call starting for:', query);
			// Show loading message with animation
			$('#suggestionsContent').html('<div class="search-suggestion-item loading">Searching products...</div>');
			$('#searchSuggestions').show();
			
			$.ajax({
				url: '<?= base_url("main/auto_search/product") ?>',
				type: 'POST',
				data: { search: query },
				success: function(response) {
					console.log('AJAX response:', response);
					if (response.trim() === '') {
						$('#suggestionsContent').html('<div class="search-suggestion-item no-results">No products found for "' + query + '"</div>');
					} else {
						$('#suggestionsContent').html(response);
					}
					$('#searchSuggestions').show();
				},
				error: function(xhr, status, error) {
					console.error('Search error:', error);
					console.error('Status:', status);
					console.error('Response:', xhr.responseText);
					$('#suggestionsContent').html('<div class="search-suggestion-item error">Search failed. Please try again.</div>');
					$('#searchSuggestions').show();
				}
			});
		}
	});

	// Language Converter Script (English and Hindi only)
	function googleTranslateElementInitHeader() {
		try {
			new google.translate.TranslateElement({
				pageLanguage: 'en',
				includedLanguages: 'en,hi',
				layout: google.translate.TranslateElement.InlineLayout.SIMPLE,
				autoDisplay: false
			}, 'google_translate_element_header');
		} catch(e) {}
	}

	(function languageDropdownInit(){
		var LABELS = { en:'English', hi:'हिंदी' };
		
		function getCookie(name){
			var cookies = document.cookie ? document.cookie.split('; ') : [];
			var value = null;
			for (var i = cookies.length - 1; i >= 0; i--) {
				var parts = cookies[i].split('=');
				if (parts[0] === name) { 
					value = decodeURIComponent(parts.slice(1).join('=')); 
					break; 
				}
			}
			return value;
		}
		
		function codeFromCookie(){
			var c = getCookie('googtrans');
			if(!c) return 'en';
			var parts = c.split('/');
			return parts[parts.length-1] || 'en';
		}
		
		function setButtonLabel(code){
			// Update desktop dropdown
			var dd = document.querySelector('.language-dropdown');
			if(dd) {
				var labelEl = dd.querySelector('.current-label');
				var label = LABELS[code] || 'English';
				if(labelEl) labelEl.textContent = label;
				dd.querySelectorAll('.lang-dropdown-box a').forEach(function(a){ 
					a.classList.toggle('active', a.getAttribute('data-lang')===code); 
				});
			}
			// Update mobile dropdown
			var ddMobile = document.querySelector('.language-dropdown-mobile');
			if(ddMobile) {
				var labelElMobile = ddMobile.querySelector('.current-label');
				var labelMobile = LABELS[code] || 'English';
				if(labelElMobile) labelElMobile.textContent = labelMobile;
				ddMobile.querySelectorAll('.lang-dropdown-box a').forEach(function(a){ 
					a.classList.toggle('active', a.getAttribute('data-lang')===code); 
				});
			}
		}
		
		function deleteCookieEverywhere(name){
			var host = window.location.hostname;
			var parts = host.split('.');
			var apex = parts.length > 2 ? parts.slice(-2).join('.') : host;
			var variants = [host, '.'+host, apex, '.'+apex];
			variants.forEach(function(dom){
				document.cookie = name + '=; expires=Thu, 01 Jan 1970 00:00:01 GMT; path=/; domain=' + dom;
				document.cookie = name + '=; expires=Thu, 01 Jan 1970 00:00:01 GMT; path=/';
			});
		}
		
		function setCookie(name, value, days){
			var d = new Date();
			d.setTime(d.getTime() + (days*24*60*60*1000));
			var expires = 'expires=' + d.toUTCString();
			var host = window.location.hostname;
			var parts = host.split('.');
			var apex = parts.length > 2 ? parts.slice(-2).join('.') : host;
			var variants = [host, '.'+apex];
			variants.forEach(function(dom){
				document.cookie = name + '=' + value + '; ' + expires + '; domain=' + dom + '; path=/';
			});
		}
		
		function setLang(code){
			// clear any previous googtrans cookies
			deleteCookieEverywhere('googtrans');
			// Try Google widget change if available
			var sel = document.querySelector('#google_translate_element_header select.goog-te-combo');
			if (sel){
				sel.value = code;
				sel.dispatchEvent(new Event('change'));
			}
			// Update button label immediately
			setButtonLabel(code);
			// Force via cookie, then reload to apply
			setCookie('googtrans', '/auto/' + code, 365);
			setCookie('googtrans', '/en/' + code, 365);
			setTimeout(function(){ location.reload(); }, 150);
		}
		
		// Handle desktop language dropdown
		var dd = document.querySelector('.language-dropdown');
		if(dd) {
			var toggle = dd.querySelector('.lang-toggle');
			if(toggle) {
				toggle.addEventListener('click', function(e){ 
					e.preventDefault(); 
					e.stopPropagation(); 
					dd.classList.toggle('open'); 
				});
			}
			
			dd.querySelectorAll('[data-lang]').forEach(function(a){ 
				a.addEventListener('click', function(e){ 
					e.preventDefault(); 
					setLang(this.getAttribute('data-lang')); 
					dd.classList.remove('open'); 
				}); 
			});
		}

		// Handle mobile language dropdown
		var ddMobile = document.querySelector('.language-dropdown-mobile');
		if(ddMobile) {
			var toggleMobile = ddMobile.querySelector('.lang-toggle');
			if(toggleMobile) {
				toggleMobile.addEventListener('click', function(e){ 
					e.preventDefault(); 
					e.stopPropagation(); 
					ddMobile.classList.toggle('open'); 
				});
			}
			
			ddMobile.querySelectorAll('[data-lang]').forEach(function(a){ 
				a.addEventListener('click', function(e){ 
					e.preventDefault(); 
					setLang(this.getAttribute('data-lang')); 
					ddMobile.classList.remove('open'); 
				}); 
			});
		}
		
		// Close dropdowns when clicking outside
		document.addEventListener('click', function(e){ 
			if(dd && !dd.contains(e.target)){ 
				dd.classList.remove('open'); 
			}
			if(ddMobile && !ddMobile.contains(e.target)){ 
				ddMobile.classList.remove('open'); 
			}
		});
		
		// Initialize label from cookie (persist selection) for both dropdowns
		var currentLang = codeFromCookie();
		if(dd) setButtonLabel(currentLang);
		if(ddMobile) {
			var labelElMobile = ddMobile.querySelector('.current-label');
			var labelMobile = LABELS[currentLang] || 'English';
			if(labelElMobile) labelElMobile.textContent = labelMobile;
			ddMobile.querySelectorAll('.lang-dropdown-box a').forEach(function(a){ 
				a.classList.toggle('active', a.getAttribute('data-lang')===currentLang); 
			});
		}
	})();

	// Bootstrap Dropdown for Categories (Simple JavaScript - No Bootstrap JS dependency)
	document.addEventListener('DOMContentLoaded', function() {
		// Handle category dropdowns
		const dropdownToggles = document.querySelectorAll('.main-menu nav ul li.dropdown .dropdown-toggle');
		
		dropdownToggles.forEach(function(toggle) {
			// Remove any existing listeners first
			var newToggle = toggle.cloneNode(true);
			toggle.parentNode.replaceChild(newToggle, toggle);
			
			newToggle.addEventListener('click', function(e) {
				// Always prevent default to stop navigation
				e.preventDefault();
				e.stopPropagation();
				e.stopImmediatePropagation();
				
				const dropdown = this.closest('.dropdown');
				if (!dropdown) {
					console.log('Dropdown not found');
					return false;
				}
				
				// Check state BEFORE any changes
				const isOpen = dropdown.classList.contains('show');
				console.log('Dropdown toggle clicked, isOpen:', isOpen, 'Dropdown:', dropdown);
				console.log('Dropdown classes:', dropdown.className);
				
				// Close all other dropdowns first
				document.querySelectorAll('.main-menu nav ul li.dropdown').forEach(function(dd) {
					if (dd !== dropdown) {
						dd.classList.remove('show');
					}
				});
				
				// Toggle current dropdown - Force the change
				if (isOpen) {
					dropdown.classList.remove('show');
					console.log('Dropdown closed - show class removed');
					
					// Force remove again to ensure it's gone
					setTimeout(function() {
						dropdown.classList.remove('show');
						console.log('After close - has show class?', dropdown.classList.contains('show'));
					}, 0);
				} else {
					dropdown.classList.add('show');
					console.log('Dropdown opened - show class added');
				}
				
				// Prevent any further event propagation
				return false;
			}, true); // Use capture phase
		});
		
		// Handle sub-submenu dropdowns - Same pattern as main dropdown
		const submenuToggles = document.querySelectorAll('.main-menu nav ul li.dropdown .dropdown-submenu .has-submenu');
		console.log('Found ' + submenuToggles.length + ' sub-submenu toggles');
		
		submenuToggles.forEach(function(toggle, index) {
			console.log('Setting up click handler for toggle ' + index, toggle);
			toggle.addEventListener('click', function(e) {
				console.log('Sub-submenu clicked!', this);
				e.preventDefault();
				e.stopPropagation();
				
				// Keep parent dropdown open
				const mainDropdown = this.closest('.main-menu nav ul li.dropdown');
				if (mainDropdown) {
					mainDropdown.classList.add('show');
				}
				
				const submenu = this.closest('.dropdown-submenu');
				console.log('Found submenu parent:', submenu);
				if (!submenu) {
					console.log('ERROR: Could not find .dropdown-submenu parent!');
					return;
				}
				
				const isOpen = submenu.classList.contains('show');
				console.log('Is open:', isOpen);
				
				// Close all other sub-submenus first
				document.querySelectorAll('.main-menu nav ul li.dropdown .dropdown-submenu').forEach(function(sm) {
					if (sm !== submenu) {
						sm.classList.remove('show');
					}
				});
				
				// Toggle current sub-submenu
				if (isOpen) {
					submenu.classList.remove('show');
					console.log('Removed show class');
				} else {
					submenu.classList.add('show');
					console.log('Added show class');
					
					// Use simple CSS-based positioning - absolute relative to parent
					var submenuEl = submenu.querySelector('.sub-submenu');
					if (submenuEl) {
						// Ensure parent dropdown menu allows overflow
						var parentMenu = submenu.closest('.dropdown-menu');
						if (parentMenu) {
							parentMenu.style.setProperty('overflow', 'visible', 'important');
							parentMenu.style.setProperty('overflow-x', 'visible', 'important');
						}
						
						// Ensure submenu item has position relative
						submenu.style.setProperty('position', 'relative', 'important');
						
						// Remove any existing inline styles
						submenuEl.removeAttribute('style');
						
						// Apply simple absolute positioning - CSS will handle it
						// The CSS rule .dropdown-submenu.show .sub-submenu already handles display
						// Just ensure it's visible
						submenuEl.style.setProperty('display', 'block', 'important');
						submenuEl.style.setProperty('visibility', 'visible', 'important');
						submenuEl.style.setProperty('opacity', '1', 'important');
						
						console.log('Sub-submenu shown using CSS absolute positioning');
					}
				}
			});
		});
		
		// Close dropdowns when clicking outside
		document.addEventListener('click', function(e) {
			// Don't close if clicking on dropdown toggle (it handles its own toggle)
			if (e.target.closest('.dropdown-toggle')) {
				return;
			}
			
			// Don't close if clicking on sub-submenu toggle or inside sub-submenu
			if (e.target.closest('.has-submenu') || e.target.closest('.sub-submenu')) {
				return;
			}
			
			const clickedDropdown = e.target.closest('.main-menu nav ul li.dropdown');
			if (!clickedDropdown) {
				document.querySelectorAll('.main-menu nav ul li.dropdown').forEach(function(dd) {
					dd.classList.remove('show');
				});
			}
			
			// Close sub-submenus when clicking outside
			const clickedSubmenu = e.target.closest('.main-menu nav ul li.dropdown .dropdown-submenu');
			if (!clickedSubmenu) {
				document.querySelectorAll('.main-menu nav ul li.dropdown .dropdown-submenu').forEach(function(sm) {
					sm.classList.remove('show');
				});
			}
		});
		
		// Prevent dropdown from closing when clicking inside dropdown menu
		// BUT allow clicks on links to work normally
		document.querySelectorAll('.main-menu nav ul li.dropdown .dropdown-menu').forEach(function(menu) {
			menu.addEventListener('click', function(e) {
				// Only stop propagation if not clicking on a link
				if (!e.target.closest('a')) {
					e.stopPropagation();
				}
			});
		});
		
		// Prevent sub-submenu from closing when clicking inside it
		document.querySelectorAll('.main-menu nav ul li.dropdown .dropdown-submenu .sub-submenu').forEach(function(menu) {
			menu.addEventListener('click', function(e) {
				e.stopPropagation();
			});
		});
		
		// Debug: Log when show class is added/removed
		var observer = new MutationObserver(function(mutations) {
			mutations.forEach(function(mutation) {
				if (mutation.type === 'attributes' && mutation.attributeName === 'class') {
					var target = mutation.target;
					if (target.classList.contains('dropdown-submenu')) {
						console.log('Submenu class changed:', target.className);
						var submenu = target.querySelector('.sub-submenu');
						if (submenu) {
							var computed = window.getComputedStyle(submenu);
							console.log('Submenu computed styles:', {
								display: computed.display,
								visibility: computed.visibility,
								opacity: computed.opacity,
								zIndex: computed.zIndex
							});
						}
					}
				}
			});
		});
		
		document.querySelectorAll('.dropdown-submenu').forEach(function(sm) {
			observer.observe(sm, { attributes: true, attributeFilter: ['class'] });
		});
	});
</script>
<script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInitHeader"></script>