<!-- Login Section Start -->


<style>
    .py-5 {
        padding-top: 6rem !important;
        padding-bottom: 3rem !important;
    }
</style>
<section class="login-section py-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-12 col-md-10 col-lg-5">
                <div class="login-content shadow-box p-4 p-md-5 bg-white rounded-3 text-center">

                    <h2 class="mb-3">Hey there! <br>Welcome back <span class="text-secondary"></span></h2>
                    <p class="mb-4 text-muted">Sign in to continue and access your account</p>

                    <form class="login-form" id="loginForm" action="<?= base_url('index.php/action/login') ?>" method="post">

                        <div class="row g-3">

                            <!-- Email -->
                            <div class="col-12">
                                <div class="form-clt">
                                    <input type="email" name="email" placeholder="Enter your email">
                                </div>
                            </div>

                            <!-- Password -->
                            <div class="col-12">
                                <div class="form-clt position-relative">
                                    <input type="password" name="pass" placeholder="Password" id="login-password">
                                    <span class="eye-icon" onclick="toggleLoginPassword()">
                                        <i id="loginToggleIcon" class="fa-solid fa-eye"></i>
                                    </span>
                                </div>
                            </div>

                            <!-- Captcha (optional, uncomment if needed) -->
                            <!-- <div class="col-12 text-center">
                                <?= get_captcha('login_captcha', 'login_form'); ?>
                            </div> -->

                            <!-- Forgot Password -->
                            <div class="col-12 text-end">
                                <a href="<?= base_url('password') ?>" class="fs-sm text-decoration-none">Forgot Password?</a>
                            </div>

                            <!-- Submit Button -->
                            <div class="col-12 mt-3">
                                <button type="submit" class="theme-btn style-2 w-100">Sign In <i class="fa-solid fa-arrow-right-long"></i></button>
                            </div>

                            <!-- Signup Link -->

                            <div class="col-12 text-center mt-3">
                                <p class="mb-0 fs-xs">Don't have an Account? <a href="<?= base_url('signup' . (isset($_GET['redirect']) ? '?redirect=' . urlencode($_GET['redirect']) : '')) ?>">Sign Up</a></p>
                            </div>

                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Error and Loader Divs -->
<div id="error_div"></div>
<div id="loder_div" style="display:none;"></div>

<!-- Password Toggle Script -->
<script>
    function toggleLoginPassword() {
        const passwordField = document.getElementById("login-password");
        const toggleIcon = document.getElementById("loginToggleIcon");

        if (passwordField.type === "password") {
            passwordField.type = "text";
            toggleIcon.classList.replace("fa-eye", "fa-eye-slash");
        } else {
            passwordField.type = "password";
            toggleIcon.classList.replace("fa-eye-slash", "fa-eye");
        }
    }

    // Handle login form submission (same approach as ed_tech)
    jQuery(document).ready(function($) {
        $('#loginForm').on('submit', function(e) {
            e.preventDefault();
            $("#error_div").empty();
            $("#loder_div").show();
            
            $.ajax({
                type: 'POST',
                url: '<?= base_url('index.php/action/login') ?>',
                data: $(this).serialize(),
                success: function(data) {
                    if($.trim(data) == 'YNAPS_SUCCESS' || $.trim(data) == 'YNAPS_SUCCESS22') {
                        // Check if there's a stored redirect URL (same approach as ed_tech)
                        <?php if (isset($_SESSION['redirect_after_login']) && !empty($_SESSION['redirect_after_login'])): ?>
                            window.location.href = '<?= $_SESSION['redirect_after_login'] ?>';
                            <?php unset($_SESSION['redirect_after_login']); ?>
                        <?php elseif (isset($redirect_url) && !empty($redirect_url)): ?>
                            window.location.href = '<?= $redirect_url ?>';
                        <?php else: ?>
                            window.location.href = '<?= base_url() ?>';
                        <?php endif; ?>
                    }
                    else {
                        $("#error_div").empty().append(data);
                        swal("Attention Needed !!", data);
                    }
                    $("#loder_div").fadeOut();
                },
                error: function() {
                    $("#error_div").empty().append('An error occurred. Please try again.');
                    $("#loder_div").fadeOut();
                }
            });
            return false;
        });
    });
</script>

<!-- Custom CSS -->
<style>
    .login-content {
        background: #fff;
        padding: 40px 30px;
        border-radius: 12px;
        box-shadow: 0 10px 30px rgba(84, 173, 222, 0.54);
        text-align: center;
    }

    .login-content h2 {
        font-size: 1.8rem;
        color: linear-gradient(90deg, #251660, #1276BB);
    }

    .login-content p {
        color: #555;
    }

    .form-clt input {
        width: 100%;
        padding: 10px 15px;
        border-radius: 8px;
        border: 1px solid #ddd;
        box-shadow: 0 5px 15px rgba(255, 123, 107, 0.15);
        transition: all 0.3s ease;
    }

    .form-clt input:focus {
        outline: none;
        border-color: linear-gradient(90deg, #251660, #1276BB);
        box-shadow: 0 5px 15px #018EDC;
    }

    .eye-icon {
        position: absolute;
        top: 50%;
        right: 12px;
        transform: translateY(-50%);
        cursor: pointer;
        color: #555;
    }

    .theme-btn.style-2 {
        background: linear-gradient(90deg, #251660, #1276BB);
        color: #fff;
        border: none;
        padding: 12px 20px;
        border-radius: -4px;
        font-weight: 600;
        transition: all 0.3s ease;
    }

    .theme-btn.style-2:hover {
        background: linear-gradient(90deg, #251660, #1276BB);
    }

    @media (max-width: 767px) {
        .login-content {
            padding: 25px 20px;
        }

        .login-content h2 {
            font-size: 1.5rem;
        }
    }
</style>