<style>
    .first,
    .second,
    .foot,
    .the_mobile_fooeter,
    .back-to-top.show {
        display: none !important;
    }
</style>
<div class="container mt-5">
    <div class="result-card shadow p-5 rounded text-center">
        <h2 class="mb-4" style="color: #FF7B6B; font-weight: bold;">
            <?= $category['category_name'] ?> - Result
        </h2>

        <!-- Score Badge -->
        <div class="score-badge mb-4">
            <?php
            $percentage = ($submission['correct_answers'] / $submission['total_questions']) * 100;
            if ($percentage >= 90) {
                $badge = 'Excellent';
            } elseif ($percentage >= 70) {
                $badge = 'Good';
            } elseif ($percentage >= 50) {
                $badge = 'Average';
            } else {
                $badge = 'Needs Improvement';
            }
            ?>
            <span class="badge"><?= $badge ?></span>
        </div>

        <!-- Progress Bar -->
        <div class="progress mb-4" style="height: 30px; border-radius: 15px;">
            <div class="progress-bar" role="progressbar" style="width: <?= $percentage ?>%; background-color: #FF7B6B;">
                <?= round($percentage) ?>%
            </div>
        </div>

        <!-- Stats Cards -->
        <div class="result-stats d-flex justify-content-around flex-wrap mb-4">
            <div class="stat-card">
                <i class="fas fa-question-circle fa-2x mb-2"></i>
                <h5>Total Questions</h5>
                <p><?= $submission['total_questions'] ?></p>
            </div>
            <div class="stat-card">
                <i class="fas fa-check-circle fa-2x mb-2"></i>
                <h5>Correct Answers</h5>
                <p><?= $submission['correct_answers'] ?></p>
            </div>
            <div class="stat-card">
                <i class="fas fa-star fa-2x mb-2"></i>
                <h5>Score</h5>
                <p><?= $submission['score'] ?></p>
            </div>
            <div class="stat-card">
                <i class="fas fa-clock fa-2x mb-2"></i>
                <h5>Submitted At</h5>
                <p><?= date('d M Y, H:i', strtotime($submission['submitted_at'])) ?></p>
            </div>
        </div>

        <a href="<?= base_url('') ?>" class="btn btn-lg btn-custom">Back to Home</a>
    </div>
</div>

<!-- Font Awesome for Icons -->
<script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>

<style>
    .result-card {
        background: rgb(255, 255, 255);
        border: 2px solid #FF7B6B;
    }

    .result-card h2 {
        font-size: 30px;
    }

    .score-badge .badge {
        font-size: 22px;
        background-color: #FF7B6B;
        color: #fff;
        padding: 10px 25px;
        border-radius: 30px;
        font-weight: bold;
    }

    .result-stats .stat-card {
        flex: 1 1 200px;
        background-color: #FF7B6B;
        color: #fff;
        margin: 10px;
        padding: 20px;
        border-radius: 15px;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        transition: transform 0.3s;
    }

    .result-stats .stat-card:hover {
        transform: translateY(-5px);
    }

    .result-stats .stat-card h5 {
        font-weight: 600;
        margin-bottom: 10px;
    }

    .result-stats .stat-card p {
        font-size: 22px;
        font-weight: bold;
    }

    .btn-custom {
        background-color: #FF7B6B;
        color: #fff;
        font-weight: bold;
        padding: 12px 30px;
        border-radius: 50px;
        text-decoration: none;
        transition: 0.3s;
    }

    .btn-custom:hover {
        background-color: #ff5a4a;
        color: #fff;
    }

    .progress {
        background-color: #ffdada;
    }

    .progress-bar {
        font-weight: bold;
        font-size: 18px;
    }
</style>