<!-- Shop Details Section Start -->
<style>
    .fa-heart:before {
        content: "\f004";
    }

    /* Product Image Gallery Styles */
    .main-product-image-wrapper {
        margin-bottom: 20px;
    }

    .main-image-container {
        position: relative;
        width: 100%;
        background: #f8f9fa;
        border-radius: 8px;
        overflow: hidden;
        padding: 20px;
        min-height: 400px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .main-image-container img {
        max-width: 100%;
        max-height: 500px;
        width: auto;
        height: auto;
        object-fit: contain;
        display: block;
        margin: 0 auto;
    }

    .image-nav-btn {
        position: absolute;
        top: 50%;
        transform: translateY(-50%);
        background: rgba(255,255,255,0.9);
        border: none;
        border-radius: 50%;
        width: 40px;
        height: 40px;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        box-shadow: 0 2px 8px rgba(0,0,0,0.2);
        z-index: 10;
        transition: all 0.3s ease;
    }

    .image-nav-btn:hover {
        background: rgba(255,255,255,1);
        box-shadow: 0 4px 12px rgba(0,0,0,0.3);
        transform: translateY(-50%) scale(1.1);
    }

    .image-nav-prev {
        left: 10px;
    }

    .image-nav-next {
        right: 10px;
    }

    .thumbnail-gallery {
        display: flex;
        gap: 10px;
        flex-wrap: wrap;
        justify-content: flex-start;
        margin-top: 15px;
    }

    .thumbnail-item {
        flex: 0 0 auto;
        width: 80px;
        height: 80px;
        border: 2px solid #e0e0e0;
        border-radius: 8px;
        overflow: hidden;
        cursor: pointer;
        position: relative;
        background: #f8f9fa;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all 0.3s ease;
    }

    .thumbnail-item:hover {
        border-color: #28a745;
        transform: scale(1.05);
    }

    .thumbnail-item.active {
        border-color: #28a745;
        box-shadow: 0 2px 8px rgba(40, 167, 69, 0.3);
    }

    .thumbnail-item img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .thumbnail-item .video-play-icon {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        width: 30px;
        height: 30px;
        background: rgba(255,255,255,0.9);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .thumbnail-item .video-play-icon i {
        color: #333;
        font-size: 12px;
        margin-left: 2px;
    }

    /* Mobile Responsive */
    @media (max-width: 768px) {
        .main-image-container {
            min-height: 300px;
            padding: 15px;
        }

        .main-image-container img {
            max-height: 350px;
        }

        .image-nav-btn {
            width: 35px;
            height: 35px;
        }

        .image-nav-btn i {
            font-size: 14px;
        }

        .thumbnail-item {
            width: 60px;
            height: 60px;
        }

        .thumbnail-gallery {
            gap: 8px;
        }
    }

    @media (max-width: 576px) {
        .main-image-container {
            min-height: 250px;
            padding: 10px;
        }

        .main-image-container img {
            max-height: 300px;
        }

        .thumbnail-item {
            width: 50px;
            height: 50px;
        }
    }

    .the_mobile_fooeter {
        display: none !important;
    }

    .shop-box-items .book-thumb img {
        max-width: 100% !important;
        transition: all 0.4s ease-in-out;
        -webkit-transition: all 0.4s ease-in-out;
        -moz-transition: all 0.4s ease-in-out;
        -ms-transition: all 0.4s ease-in-out;
        -o-transition: all 0.4s ease-in-out;
        object-fit: contain;
    }

    /* Also May You Like section - Match home.php and shop.php exactly */
    /* Make rows use flexbox for equal height columns */
    .also-may-like-row {
        display: flex !important;
        flex-wrap: wrap !important;
        align-items: stretch !important;
    }
    
    .also-may-like-row > [class*="col-"] {
        padding-left: 12px !important;
        padding-right: 12px !important;
        display: flex !important;
        flex-direction: column !important;
    }

    /* Card container - no padding, no border, use flexbox for consistent alignment */
    .also-may-like-row .shop-box-items {
        padding: 0 !important;
        margin: 0 !important;
        width: 100% !important;
        height: 100% !important;
        overflow: hidden;
        border: none !important;
        box-sizing: border-box;
        display: flex !important;
        flex-direction: column !important;
    }

    /* Book thumb - completely flush, no padding, no border, no shadow */
    .also-may-like-row .shop-box-items .book-thumb {
        padding: 0 !important;
        margin: 0 !important;
        width: 100% !important;
        min-height: 239px !important;
        height: auto !important;
        border: none !important;
        border-radius: 0 !important;
        overflow: visible !important;
        display: block !important;
        box-sizing: border-box;
        box-shadow: none !important;
        background-color: transparent !important;
        position: relative;
        flex-shrink: 0 !important;
    }

    /* Link wrapper - full width and height */
    .also-may-like-row .shop-box-items .book-thumb a {
        display: block !important;
        width: 100% !important;
        height: 100% !important;
        padding: 0 !important;
        margin: 0 !important;
    }

    /* Image - 100% width to match text, with contain to show full image without cutting */
    .also-may-like-row .shop-box-items .book-thumb img {
        width: 100% !important;
        max-width: 100% !important;
        min-width: 100% !important;
        height: auto !important;
        object-fit: contain !important;
        object-position: center !important;
        display: block !important;
        margin: 0 !important;
        padding: 0 !important;
        border-radius: 0 !important;
        border: none !important;
        box-sizing: border-box !important;
    }

    /* Shop content - consistent styling */
    .also-may-like-row .shop-box-items .shop-content {
        padding: 15px 10px !important;
        flex-grow: 1 !important;
        display: flex !important;
        flex-direction: column !important;
    }

    .also-may-like-row .shop-box-items .shop-content h5 {
        font-size: 12px;
        color: #666;
        margin-bottom: 5px;
    }

    .also-may-like-row .shop-box-items .shop-content h3 {
        color: var(--header);
        font-family: "Inter", sans-serif;
        font-size: 14px;
        font-style: normal;
        font-weight: 700;
        line-height: 26px;
        text-transform: capitalize;
        margin-bottom: 5px;
    }

    .also-may-like-row .shop-box-items .shop-content .price-list {
        display: flex;
        margin-top: 0px;
        justify-content: start;
        gap: 9px;
    }

    .also-may-like-row .shop-box-items .shop-content .author-post {
        display: flex;
        align-items: center;
        justify-content: space-between;
        margin-top: -2px;
    }

    /* Shop button - push to bottom */
    .also-may-like-row .shop-box-items .shop-button {
        margin-top: auto !important;
        padding: 10px !important;
    }

    /* Hide on desktops */
    /* Hide .mob only on desktop */
    @media (min-width: 992px) {
        .mob {
            display: none !important;
        }
    }

    .hero-1 .girl-img img {
        width: 100%;
        height: 100%;
        margin-bottom: 203px;
    }

    @media screen and (max-width:576px) {
        .shop-box-items .book-thumb img {
            max-width: 100% !important;
            transition: all 0.4s ease-in-out;
            -webkit-transition: all 0.4s ease-in-out;
            -moz-transition: all 0.4s ease-in-out;
            -ms-transition: all 0.4s ease-in-out;
            -o-transition: all 0.4s ease-in-out;
            object-fit: contain;
        }

        .shop-box-items .book-thumb {
            text-align: center;
            padding: 8px 0 !important;
        }

        /* Also May You Like section mobile styling */
        .also-may-like-row .shop-box-items .book-thumb {
            min-height: 224px !important;
        }

        .also-may-like-row .shop-box-items .book-thumb img {
            width: 120% !important;
            height: 100% !important;
            object-fit: contain !important;
            margin: 0 auto !important;
            display: block !important;
        }

        .shop-box-items .shop-content {
            margin-top: 10px;
        }

        @media (max-width: 575px) {
            .theme-btn {
                padding: 12px 30px;
                font-size: 14px;

            }
        }

        .shop-box-items.style-2 .shop-content h3 {
            color: var(--header);
            font-family: "Inter", sans-serif;
            font-size: 14px;
            font-style: normal;
            font-weight: 700;
            line-height: 26px;
            text-transform: capitalize;
            margin-bottom: 5px;
        }



        .shop-box-items.style-2 .shop-content .price-list {
            display: flex;
            margin-top: 0px;
            justify-content: start;
            gap: 9px;
        }

        .shop-box-items.style-2 .shop-content .author-post {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-top: -2px;
        }

        .star {
            font-size: 8px;
        }

        /* ✅ Control book cover thumbnail size */
        .shop-box-items .book-thumb img {
            width: 125px;
            /* reduce width */
            height: auto;
            /* keep aspect ratio */
            object-fit: contain;
            margin: 0 auto;
            /* center horizontally */
            display: block;
        }

        /* ✅ Optionally fix the book-thumb area */
        .shop-box-items .book-thumb {
            text-align: center;
            padding: 10px;
        }


        .shop-box-items .book-thumb {
            background-color: var(--bg);
            padding: 30px;
            border-radius: 10px;
            position: relative;
            overflow: hidden;
            height: 224px !important;
        }
    }

    .shop-box-items .book-thumb {
        background-color: var(--bg);
        padding: 17px;
        border-radius: 10px;
        position: relative;
        overflow: hidden;
        height: 239px;
    }

    @media (min-width: 992px) {
        .col-lg-3 {
            flex: 0 0 auto;
            width: 16%;
        }
    }

    .shop-box-items .book-thumb img {
        width: 121px;
        /* fixed width */
        height: 203px;
        /* fixed height for uniform look */
        object-fit: contain;
        /* keeps aspect ratio without cropping */
        margin: 0 auto;
        /* center the image */
        display: block;
        /* ensures centering works */
    }

    @media screen and (max-width: 576px) {
        .shop-box-items .book-thumb img {
            width: 121px;
            height: 180px;
            object-fit: contain;
            margin: 0 auto;
            display: block;
        }
    }

    @media screen and (max-width: 576px) {
        .shop-box-items .book-thumb img {
            width: 121px;
            height: 180px;
            object-fit: contain;
            margin: 0 auto;
            display: block;
        }
    }

    .book-catagories-wrapper .book-catagories-items .book-thumb {
        position: relative;
        padding: 14px 18px 27px;
        background-color: var(--white);
        border-radius: 10px;
        margin-bottom: 30px;
        transition: all 0.4s ease-in-out;
        -webkit-transition: all 0.4s ease-in-out;
        -moz-transition: all 0.4s ease-in-out;
        -ms-transition: all 0.4s ease-in-out;
        -o-transition: all 0.4s ease-in-out;
    }

    /* Clean Light Design */
    .shop-details-image {
        background: #f8f9fa;
        border-radius: 12px;
        padding: 20px;
        text-align: center;
        border: 2px solid #e9ecef;
        box-shadow: 0 4px 12px rgba(0,0,0,0.08);
        min-height: 380px;
        display: flex;
        align-items: center;
        justify-content: center;
        position: relative;
    }

    .shop-details-thumb {
        background: white;
        border-radius: 8px;
        padding: 12px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        border: 1px solid #dee2e6;
        transition: all 0.3s ease;
        max-width: 280px;
    }

    .shop-details-thumb:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 16px rgba(0,0,0,0.15);
    }

    .shop-details-thumb img {
        max-width: 100% !important;
        max-height: 300px !important;
        width: auto !important;
        height: auto !important;
        object-fit: contain !important;
        border-radius: 6px !important;
        display: block !important;
        transition: all 0.3s ease;
    }

    .shop-details-thumb img:hover {
        transform: scale(1.02);
    }

    /* Mobile Responsive */
    @media (max-width: 768px) {
        .shop-details-image {
            padding: 15px;
            min-height: 300px;
        }
        
        .shop-details-thumb {
            padding: 10px;
            max-width: 250px;
        }
        
        .shop-details-thumb img {
            max-height: 280px !important;
        }
    }

    @media (max-width: 576px) {
        .shop-details-image {
            padding: 12px;
            min-height: 250px;
        }
        
        .shop-details-thumb {
            padding: 8px;
            max-width: 200px;
        }
        
        .shop-details-thumb img {
            max-height: 220px !important;
        }
    }
</style>
<section class="shop-details-section fix section-padding">
    <div class="container">
        <div class="shop-details-wrapper">
            <div class="row g-4">
                <!-- Product Images -->
                <div class="col-lg-4">
                    <div class="shop-details-image">
                        <!-- Main Product Image with Navigation -->
                        <div class="main-product-image-wrapper" style="position: relative; margin-bottom: 20px;">
                            <div class="main-image-container" style="position: relative; width: 100%; background: #f8f9fa; border-radius: 8px; overflow: hidden; padding: 20px; min-height: 400px; display: flex; align-items: center; justify-content: center;">
                            <?php
                                // Get all images including cover image
                                $all_images = [];
                                
                                // Add cover image first if exists
                                if (!empty($product['p_cover'])) {
                                    $all_images[] = [
                                        'img' => $product['p_cover'],
                                        'type' => 'image'
                                    ];
                                }
                                
                                // Add other product images
                                if (!empty($prod_img)) {
                                    foreach ($prod_img as $img) {
                                        if (!empty($img['img'])) {
                                            $all_images[] = [
                                                'img' => $img['img'],
                                                'type' => isset($img['type']) ? $img['type'] : 'image'
                                            ];
                                        }
                                    }
                                }
                                
                                // If no images at all, use cover or placeholder
                                if (empty($all_images) && !empty($product['p_cover'])) {
                                    $all_images[] = [
                                        'img' => $product['p_cover'],
                                        'type' => 'image'
                                    ];
                                }
                                
                                if (!empty($all_images)) {
                                    $first_image = $all_images[0];
                                    $imagePath = base_url('assets/avator/upload/' . $first_image['img']);
                                    
                                    echo '<img id="mainProductImage" src="' . $imagePath . '" alt="Product Image" style="max-width: 100%; max-height: 500px; width: auto; height: auto; object-fit: contain; display: block; margin: 0 auto;">';
                                    
                                    // Navigation arrows (only show if more than 1 image)
                                    if (count($all_images) > 1) {
                                        echo '<button class="image-nav-btn image-nav-prev" onclick="changeMainImage(-1)" style="position: absolute; top: 50%; left: 10px; transform: translateY(-50%); background: rgba(255,255,255,0.9); border: none; border-radius: 50%; width: 40px; height: 40px; cursor: pointer; display: flex; align-items: center; justify-content: center; box-shadow: 0 2px 8px rgba(0,0,0,0.2); z-index: 10;">';
                                        echo '    <i class="fa fa-chevron-left" style="color: #333; font-size: 18px;"></i>';
                                        echo '</button>';
                                        
                                        echo '<button class="image-nav-btn image-nav-next" onclick="changeMainImage(1)" style="position: absolute; top: 50%; right: 10px; transform: translateY(-50%); background: rgba(255,255,255,0.9); border: none; border-radius: 50%; width: 40px; height: 40px; cursor: pointer; display: flex; align-items: center; justify-content: center; box-shadow: 0 2px 8px rgba(0,0,0,0.2); z-index: 10;">';
                                        echo '    <i class="fa fa-chevron-right" style="color: #333; font-size: 18px;"></i>';
                                        echo '</button>';
                                    }
                            } else {
                                    echo '<p style="text-align: center; color: #999; padding: 40px;">No images available</p>';
                            }
                            ?>
                            </div>
                        </div>
                        
                        <!-- Thumbnail Gallery -->
                        <?php if (!empty($all_images) && count($all_images) > 0): ?>
                        <div class="thumbnail-gallery" style="display: flex; gap: 10px; flex-wrap: wrap; justify-content: flex-start; margin-top: 15px;">
                            <?php foreach ($all_images as $index => $img): 
                                $thumbPath = base_url('assets/avator/upload/' . $img['img']);
                                $isActive = ($index === 0) ? 'active' : '';
                                $isVideo = (isset($img['type']) && $img['type'] === 'video');
                            ?>
                                <div class="thumbnail-item <?= $isActive ?>" 
                                     onclick="selectThumbnail(<?= $index ?>)"
                                     data-image-index="<?= $index ?>"
                                     data-image-path="<?= $thumbPath ?>"
                                     style="flex: 0 0 auto; width: 80px; height: 80px; border: 2px solid <?= $isActive ? '#28a745' : '#e0e0e0' ?>; border-radius: 8px; overflow: hidden; cursor: pointer; position: relative; background: #f8f9fa; display: flex; align-items: center; justify-content: center; transition: all 0.3s ease;">
                                    <?php if ($isVideo): ?>
                                        <img src="<?= $thumbPath ?>" alt="Video Thumbnail" style="width: 100%; height: 100%; object-fit: cover; opacity: 0.7;">
                                        <div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 30px; height: 30px; background: rgba(255,255,255,0.9); border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                                            <i class="fa fa-play" style="color: #333; font-size: 12px; margin-left: 2px;"></i>
                                        </div>
                                    <?php else: ?>
                                        <img src="<?= $thumbPath ?>" alt="Thumbnail <?= $index + 1 ?>" style="width: 100%; height: 100%; object-fit: cover;">
                                    <?php endif; ?>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        
                        <script>
                            var productImages = <?= json_encode(array_map(function($img) {
                                return base_url('assets/avator/upload/' . $img['img']);
                            }, $all_images)) ?>;
                            var currentImageIndex = 0;
                            
                            function selectThumbnail(index) {
                                currentImageIndex = index;
                                var imagePath = productImages[index];
                                
                                // Update main image
                                document.getElementById('mainProductImage').src = imagePath;
                                
                                // Update active thumbnail
                                document.querySelectorAll('.thumbnail-item').forEach(function(item, idx) {
                                    if (idx === index) {
                                        item.classList.add('active');
                                        item.style.borderColor = '#28a745';
                                    } else {
                                        item.classList.remove('active');
                                        item.style.borderColor = '#e0e0e0';
                                    }
                                });
                            }
                            
                            function changeMainImage(direction) {
                                var newIndex = currentImageIndex + direction;
                                
                                if (newIndex < 0) {
                                    newIndex = productImages.length - 1;
                                } else if (newIndex >= productImages.length) {
                                    newIndex = 0;
                                }
                                
                                selectThumbnail(newIndex);
                            }
                            
                            // Keyboard navigation
                            document.addEventListener('keydown', function(e) {
                                if (e.key === 'ArrowLeft') {
                                    changeMainImage(-1);
                                } else if (e.key === 'ArrowRight') {
                                    changeMainImage(1);
                                }
                            });
                        </script>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Product Info -->
                <div class="col-lg-8">
                    <div class="shop-details-content">

                        <div class="title-wrapper">
                            <h2><?= $product['p_name'] ?></h2>
                            <!-- <h5><?= $product['p_stock'] ?? 'Stock availability.' ?></h5> -->
                        </div>


                        <div class="star">
                            <?= ratings_star($product['p_star'], 'star', '20px') ?>
                            <span>(<?= $product['p_review_count']  ?> Customer Reviews)</span>
                        </div>


                        <p><?= $product['p_descp'] ?></p>

                        <!-- Price -->
                        <div class="price-list">
                            <h3>₹<?= $product['p_price'] ?></h3>
                        </div>

                        <!-- Cart Section -->
                        <div class="cart-wrapper" style="display: flex; flex-wrap: wrap; gap: 10px; justify-content: flex-start; align-items: center;">
                            <!-- Read More Modal Trigger -->
                            <div class="icon-box mob">
                                <a href="javascript:void(0);" class="wishlist-btn icon" data-product="<?= $product['p_id'] ?? 0 ?>">
                                    <i class="far fa-heart"></i>
                                </a>
                            </div>

                            <?php
                            $pdf_file = $product['p_softcopy'];
                            $file_path = FCPATH . 'assets/avator/upload/' . $pdf_file;

                            // Check if PDF exists
                            if (!empty($pdf_file) && file_exists($file_path)):
                                $pdf_url = base_url('assets/avator/upload/' . rawurlencode($pdf_file));
                            ?>
                                <!-- Button to trigger modal -->
                                <button type="button" class="theme-btn style-2 read-btn" data-bs-toggle="modal" data-bs-target="#readMoreModal">
                                    Read A little
                                </button>

                                <!-- Read More Modal -->
                                <div class="modal fade" id="readMoreModal" tabindex="-1" aria-labelledby="readMoreModalLabel" aria-hidden="true">
                                    <div class="modal-dialog modal-xl modal-dialog-scrollable">
                                        <div class="modal-content">
                                            <div class="modal-body" style="background-image: url('<?= base_url("assets/img/popupBg.png") ?>');">
                                                <div class="close-btn">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="readMoreBox">
                                                    <h5>Digital Book Preview:</h5>
                                                    <iframe src="<?= $pdf_url ?>#toolbar=0" width="100%" height="600" style="border:none;"></iframe>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <div class="cart-wrapper addtocart-fixed">
                                <?= add_tocart3('Add To Cart', $product['p_id']) ?>
                            </div>

                            <style>
                                @media screen and (max-width:576px) {
                                    .desk {
                                        display: none !important;
                                    }

                                }

                                @media (max-width: 767px) {

                                    .cart-wrapper.addtocart-fixed {
                                        position: fixed;
                                        bottom: 0;
                                        left: 0;
                                        width: 100%;
                                        background-color: #fff;
                                        padding: 10px 15px;
                                        box-shadow: 0 -2px 8px rgba(0, 0, 0, 0.15);
                                        display: flex;
                                        justify-content: center;
                                        align-items: center;
                                        z-index: 9999;
                                    }

                                    .cart-wrapper.addtocart-fixed .theme-btn {
                                        flex: 1;
                                        /* full width */
                                        max-width: none;
                                        text-align: center;
                                        padding: 14px 0;
                                        font-size: 16px;
                                    }

                                    /* Ensure page content isn't hidden */

                                }

                                /* Desktop (normal inline button) */
                                @media (min-width: 768px) {
                                    .cart-wrapper.addtocart-fixed {
                                        position: static;
                                        width: auto;
                                        box-shadow: none;
                                        padding: 0;
                                        display: block;
                                    }

                                    .cart-wrapper.addtocart-fixed .theme-btn {
                                        flex: none;
                                        max-width: 250px;
                                        /* optional */
                                        width: auto;
                                        padding: 12px 20px;
                                    }


                                }

                                /* Button styling */
                                .cart-wrapper.addtocart-fixed .theme-btn {
                                    background: linear-gradient(90deg, #251660, #1276BB);
                                    color: white !important;
                                    font-weight: 600;
                                    border-radius: 8px;
                                    border: none;
                                    box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15);
                                    transition: all 0.3s ease;
                                }

                                .cart-wrapper.addtocart-fixed .theme-btn:hover {
                                    background-color: #e65b50;
                                    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
                                    transform: translateY(-2px);
                                }
                            </style>



                            <!-- Wishlist -->
                            <?php
                            $wishIconClass = 'fa-regular';
                            if (isset($_SESSION['yid'])) {
                                $checkWish = $this->db->query(
                                    "SELECT * FROM wishlist WHERE user_id=? AND product_id=?",
                                    [$_SESSION['yid'], $product['p_id']]
                                )->row();
                                if ($checkWish) $wishIconClass = 'fa-solid';
                            }
                            ?>
                            <div class="icon-box desk">
                                <a href="javascript:void(0);" class="wishlist-btn icon" data-product="<?= $product['p_id'] ?? 0 ?>">
                                    <i class="fa-heart <?= $wishIconClass ?>"></i>
                                </a>
                            </div>

                        </div>

                        <style>
                            /* Mobile styling only */
                            @media (max-width: 767px) {
                                .cart-wrapper {
                                    justify-content: center;
                                    gap: 10px;
                                }

                                /* Read and Add buttons full width */
                                .cart-wrapper .read-btn,
                                .cart-wrapper .addtocart-btn {
                                    width: 100% !important;
                                    display: block;
                                    text-align: center;
                                }
                            }
                        </style>

                        <!-- Product Meta Info -->
                        <div class="category-box">
                            <h3 class="product-title"><?= htmlspecialchars($product['product_name'] ?? 'Untitled Product') ?></h3>

                            <div class="category-list">
                                <?php
                                $cat = $this->db->query("SELECT name FROM yn_site_catagory WHERE ctid = ?", [$product['p_category']])->row_array();
                                $category_name = !empty($cat['name']) ? $cat['name'] : '';
                                $author_name = !empty($author['img_head']) ? $author['img_head'] : (!empty($product['p_vendor']) ? $product['p_vendor'] : '');

                                $fields = [
                                    'SKU' => $product['p_sku'] ?? '',
                                    'Category' => $category_name,
                                    'Author' => $author_name,
                                    'Tags' => $product['p_tags'] ?? '',
                                    'Total Pages' => $product['p_total_page'] ?? '',
                                    'Language' => $product['p_language'] ?? '',
                                    'Availability' => $product['p_stock'] ?? '',
                                    'Pages' => $product['p_size'] ?? '',
                                    'Shipping Location' => $product['p_shipping_location'] ?? '',
                                    'Shipping Cost' => !empty($product['p_shipping_cost']) ? '₹' . $product['p_shipping_cost'] : '',
                                    'Price' => !empty($product['p_price']) ? '₹' . $product['p_price'] : '',
                                    'MRP' => !empty($product['p_mrp']) ? '₹' . $product['p_mrp'] : '',
                                ];

                                foreach ($fields as $label => $value) {
                                    if (!empty($value)) {
                                        echo "<div class='category-item'>
                        <span class='label'><b>$label:</b></span>
                        <span class='value'>$value</span>
                      </div>";
                                    }
                                }
                                ?>
                            </div>
                        </div>

                        <style>
                            .category-box {
                                margin-bottom: 30px;
                            }

                            .product-title {
                                font-size: 1.6rem;
                                font-weight: 600;
                                margin-bottom: 20px;
                            }

                            .category-list {
                                display: flex;
                                flex-wrap: wrap;
                                gap: 15px;
                                /* increased gap for better spacing */
                            }

                            .category-item {
                                flex: 0 0 48%;
                                /* 2 columns on desktop */
                                display: flex;
                                justify-content: space-between;
                                padding: 8px 12px;
                                border: 1px solid #e0e0e0;
                                border-radius: 6px;
                                background-color: #f9f9f9;
                            }

                            .category-item .label {
                                font-weight: 500;
                                color: #333;
                            }

                            .category-item .value {
                                font-weight: 400;
                                color: #555;
                                text-align: right;
                            }

                            /* Mobile view: full width for each field */
                            @media (max-width: 768px) {
                                .category-item {
                                    flex: 0 0 100%;
                                }
                            }
                        </style>





                        <!-- Extra Info -->
                        <div class="box-check">
                            <div class="check-list">
                                <ul>
                                    <li><i class="fa-solid fa-check"></i> Free shipping orders from ₹150</li>
                                    <li><i class="fa-solid fa-check"></i> 30 days exchange & return</li>
                                </ul>
                                <ul>
                                    <li><i class="fa-solid fa-check"></i> Flash Discount: Starting at 30% Off</li>
                                    <li><i class="fa-solid fa-check"></i> Safe & Secure online shopping</li>
                                </ul>
                            </div>
                        </div>

                        <!-- Social Links -->

                    </div>
                </div>

            </div>

            <!-- Tabs Section -->
            <div class="single-tab section-padding pb-0">
                <ul class="nav mb-5" role="tablist">
                    <li class="nav-item"><a href="#description" data-bs-toggle="tab" class="nav-link ps-0 active">
                            <h6>Description</h6>
                        </a></li>
                    <li class="nav-item"><a href="#additional" data-bs-toggle="tab" class="nav-link">
                            <h6>Additional Information</h6>
                        </a></li>
                    <li class="nav-item"><a href="#review" data-bs-toggle="tab" class="nav-link">
                            <h6>Reviews</h6>
                        </a></li>
                </ul>
                <div class="tab-content">
                    <div id="description" class="tab-pane fade show active"><?= $product['p_descp'] ?></div>
                    <div id="additional" class="tab-pane fade">
                        <table class="table table-bordered">
                            <table class="table table-bordered">
                                <tbody>
                                    <tr>
                                        <td>SKU</td>
                                        <td><?= $product['p_sku'] ?? 'N/A' ?></td>
                                    </tr>
                                    <tr>
                                        <td>Category</td>
                                        <td>
                                            <?php
                                            // Fetch category name
                                            $cat = $this->db->query("SELECT name FROM yn_site_catagory WHERE ctid = ?", [$product['p_category']])->row_array();
                                            echo !empty($cat['name']) ? htmlspecialchars($cat['name']) : 'General';
                                            ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Author</td>
                                        <td>
                                            <?php
                                            // Author name
                                            $author_name = !empty($author['img_head']) ? $author['img_head'] : (!empty($product['p_vendor']) ? $product['p_vendor'] : 'Unknown Author');
                                            echo htmlspecialchars($author_name);
                                            ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Tags</td>
                                        <td><?= $product['p_tags'] ?? '—' ?></td>
                                    </tr>
                                    <tr>
                                        <td>Availability</td>
                                        <td><?= !empty($product['p_stock']) ? $product['p_stock'] : 'Available' ?></td>
                                    </tr>
                                    <tr>
                                        <td>Weight</td>
                                        <td><?= $product['p_weight'] ?? '—' ?></td>
                                    </tr>
                                    <tr>
                                        <td>Color (Benefits)</td>
                                        <td><?= $product['p_color'] ?? '—' ?></td>
                                    </tr>
                                    <tr>
                                        <td>Size (Pages)</td>
                                        <td><?= $product['p_size'] ?? '—' ?></td>
                                    </tr>
                                    <tr>
                                        <td>Shipping Location</td>
                                        <td><?= $product['p_shipping_location'] ?? 'Worldwide' ?></td>
                                    </tr>
                                    <tr>
                                        <td>Shipping Cost</td>
                                        <td>₹<?= $product['p_shipping_cost'] ?? '0' ?></td>
                                    </tr>
                                    <tr>
                                        <td>Price</td>
                                        <td>
                                            ₹<?= $product['p_price'] ?? '0' ?>
                                            <?php if (!empty($product['p_mrp'])): ?>
                                                <strike class="text-danger">₹<?= $product['p_mrp'] ?></strike>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                </tbody>

                            </table>


                    </div>

                    <div id="review" class="tab-pane fade"><?= get_web_elements('disqs', '1', '1'); ?></div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Related Products -->
<section class="shop-section section-padding fix pt-0 mb-5">
    <div class="container">
        <div class="section-title-area d-flex justify-content-between align-items-center">
            <div class="section-title">
                <h2 class="wow fadeInUp" data-wow-delay=".3s">Also May You Like</h2>
            </div>
            <a href="<?= base_url('shop') ?>" class="theme-btn style-2 fadeInUp" data-wow-delay=".5s">
                Explore More <i class="fa-solid fa-arrow-right-long"></i>
            </a>
        </div>

        <div class="row g-2 also-may-like-row">
            <?php if (!empty($featuredProducts)): ?>
                <?php foreach ($featuredProducts as $pro):
                    $url = base_url('product') . '/' . $pro['p_id'] . '/' . url_smart($pro['p_name']);
                    $cat = $this->db->query("SELECT name FROM yn_site_catagory WHERE ctid = ?", [$pro['p_category']])->row_array();
                ?>
                    <div class="col-6 col-md-4 col-lg-3">
                        <div class="shop-box-items style-2 h-100">
                            <div class="book-thumb center">
                                <a href="<?= $url ?>">
                                    <img src="<?= base_url('assets/avator/upload/' . $pro['p_cover']) ?>"
                                        alt="<?= htmlspecialchars($pro['p_name']) ?>">
                                </a>
                                <ul class="post-box">
                                    <?php if ($pro['p_mrp'] > $pro['p_price']): ?>
                                        <li>
                                            -<?= round((($pro['p_mrp'] - $pro['p_price']) / $pro['p_mrp']) * 100) ?>%
                                        </li>
                                    <?php endif; ?>
                                </ul>

                            </div>
                            <div class="shop-content">
                                <h5><?= !empty($cat['name']) ? $cat['name'] : 'Design Low Book' ?></h5>
                                <h3>
                                    <a href="<?= $url ?>"><?= htmlspecialchars($pro['p_name']) ?></a>
                                </h3>
                                <ul class="price-list">
                                    <li>₹<?= number_format($pro['p_price'], 2) ?></li>
                                    <?php if ($pro['p_mrp'] > $pro['p_price']): ?>
                                        <li><del>₹<?= number_format($pro['p_mrp'], 2) ?></del></li>
                                    <?php endif; ?>
                                </ul>
                                <ul class="author-post">
                                    <li class="authot-list">
                                        <span class="content"><?= htmlspecialchars($pro['p_author'] ?? $pro['p_vendor']) ?></span>
                                    </li>
                                    <li class="star">
                                        <?php for ($i = 1; $i <= 5; $i++): ?>
                                            <i class="fa-<?= $i <= $pro['p_star'] ? 'solid' : 'regular' ?> fa-star"></i>
                                        <?php endfor; ?>
                                    </li>
                                </ul>

                            </div>
                            <div class="shop-button">
                                <a href="<?= $url ?>" class="theme-btn">Buy Now</a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</section>


<script>
    jQuery(document).ready(function($) {
        $('.add-to-cart').on('click', function(e) {
            e.preventDefault();
            let pid = $(this).data('id');

            $.ajax({
                url: '<?= base_url("index.php/action/add_to_cart") ?>',
                method: 'POST',
                data: {
                    pid: pid
                },
                success: function(res) {
                    if (res === 'YNAPS_SUCCESS') {
                        // Update cart count dynamically
                        let currentCount = parseInt($('#cart-count').text()) || 0;
                        $('#cart-count').text(currentCount + 1);

                        // Optionally update total
                        $.get('<?= base_url("index.php/action/get_cart_total") ?>', function(total) {
                            $('#cart-total').text('₹' + total);
                        });

                        alert('Product added to cart!');
                    } else if (res === 'login_required') {
                        window.location = '<?= base_url("login") ?>';
                    } else {
                        alert(res);
                    }
                }
            });
        });
    });
</script>
<script>
    $(document).ready(function() {
        $('.wishlist-btn').click(function() {
            var product_id = $(this).data('product');
            var btn = $(this);

            <?php if (!isset($_SESSION['yid'])): ?>
                window.location.href = "<?= base_url('login') ?>";
                return;
            <?php endif; ?>

            $.ajax({
                url: "<?= base_url('index.php/action/wishlist_toggle') ?>",
                type: "POST",
                data: {
                    product_id: product_id
                },
                dataType: "json",
                success: function(res) {
                    if (res.status === 'added') {
                        btn.find('i').removeClass('fa-regular').addClass('fa-solid');
                        Swal.fire({
                            icon: 'success',
                            title: 'Added to Wishlist',
                            toast: true,
                            position: 'top-end',
                            timer: 1500,
                            showConfirmButton: false
                        });
                    } else if (res.status === 'removed') {
                        btn.find('i').removeClass('fa-solid').addClass('fa-regular');
                        Swal.fire({
                            icon: 'info',
                            title: 'Removed from Wishlist',
                            toast: true,
                            position: 'top-end',
                            timer: 1500,
                            showConfirmButton: false
                        });
                    }
                    // Update header count
                    $('.header-icon .number').text(res.count);
                },
                error: function() {
                    Swal.fire({
                        icon: 'error',
                        title: 'Something went wrong!',
                        toast: true,
                        position: 'top-end',
                        timer: 1500,
                        showConfirmButton: false
                    });
                }
            });
        });
    });
</script>