<div class="breadcrumb-wrapper bg-cover section-padding"
    style="background: linear-gradient(#E8F6FE), 
                     url('<?= base_url('assets/theme/theme/') ?>assets/img/hero/banner.jpg'); 
            background-size: cover;
            background-position: center;">
    <div class="container">
        <div class="page-heading">
            <h1>Recorded Video Details</h1>
            <div class="page-header">
                <ul class="breadcrumb-items wow fadeInUp" data-wow-delay=".3s">
                    <li><a href="<?= base_url() ?>">Home</a></li>
                    <li><a href="<?= base_url('profile') ?>">Profile</a></li>
                    <li><a href="<?= base_url('recorded_videos') ?>">Recorded Videos</a></li>
                    <li>Details</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<section class="py-5" style="background: #f5f7fa; min-height: 60vh; margin-bottom: 100px;">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="card shadow-lg border-0">
                    <div class="card-header bg-primary text-white py-4">
                        <div class="d-flex justify-content-between align-items-start">
                            <div>
                                <?php if (!empty($live_class)): ?>
                                    <h4 class="mb-2"><?= htmlspecialchars($live_class['lc_title']) ?></h4>
                                    <p class="mb-0 text-white-50">
                                        <i class="fas fa-chalkboard-teacher me-2"></i>Live Class Recording
                                    </p>
                                <?php elseif (!empty($study_material)): ?>
                                    <h4 class="mb-2"><?= htmlspecialchars($study_material['sm_name']) ?></h4>
                                    <p class="mb-0 text-white-50">
                                        <i class="fas fa-book me-2"></i>Study Material Videos
                                    </p>
                                <?php endif; ?>
                            </div>
                            <a href="<?= base_url('recorded_videos') ?>" class="btn btn-light btn-sm">
                                <i class="fas fa-arrow-left me-1"></i> Back
                            </a>
                        </div>
                    </div>
                    
                    <div class="card-body p-4">
                        <!-- Study Material / Live Class Info -->
                        <?php if (!empty($study_material)): ?>
                            <div class="mb-4">
                                <h6 class="text-primary mb-3"><i class="fas fa-book me-2"></i>Study Material Information</h6>
                                <div class="info-box p-3 bg-light rounded">
                                    <h5 class="mb-2"><?= htmlspecialchars($study_material['sm_name']) ?></h5>
                                    <?php if (!empty($study_material['sm_desc'])): ?>
                                        <p class="text-muted mb-2"><?= nl2br(htmlspecialchars($study_material['sm_desc'])) ?></p>
                                    <?php endif; ?>
                                    <?php if (!empty($study_material['course_name'])): ?>
                                        <p class="mb-0">
                                            <i class="fas fa-graduation-cap me-2"></i>
                                            <strong>Course:</strong> <?= htmlspecialchars($study_material['course_name']) ?>
                                        </p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if (!empty($live_class)): ?>
                            <div class="mb-4">
                                <h6 class="text-primary mb-3"><i class="fas fa-chalkboard-teacher me-2"></i>Live Class Information</h6>
                                <div class="info-box p-3 bg-light rounded">
                                    <h5 class="mb-2"><?= htmlspecialchars($live_class['lc_title']) ?></h5>
                                    <?php if (!empty($live_class['lc_description'])): ?>
                                        <p class="text-muted mb-2"><?= nl2br(htmlspecialchars($live_class['lc_description'])) ?></p>
                                    <?php endif; ?>
                                    <div class="row mt-3">
                                        <div class="col-md-6">
                                            <p class="mb-2">
                                                <i class="fas fa-calendar-alt me-2"></i>
                                                <strong>Date:</strong> <?= date_format_1($live_class['lc_date'], '1') ?>
                                            </p>
                                        </div>
                                        <div class="col-md-6">
                                            <p class="mb-2">
                                                <i class="fas fa-clock me-2"></i>
                                                <strong>Time:</strong> 
                                                <?= date('h:i A', strtotime($live_class['lc_start_time'])) ?> - 
                                                <?= date('h:i A', strtotime($live_class['lc_end_time'])) ?>
                                            </p>
                                        </div>
                                    </div>
                                    <?php if (!empty($live_class['course_name'])): ?>
                                        <p class="mb-0">
                                            <i class="fas fa-graduation-cap me-2"></i>
                                            <strong>Course:</strong> <?= htmlspecialchars($live_class['course_name']) ?>
                                        </p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>

                        <!-- Videos Section -->
                        <?php if (!empty($recorded_videos)): ?>
                            <div class="mb-4">
                                <h6 class="text-primary mb-3">
                                    <i class="fas fa-video me-2"></i>Recorded Videos (<?= count($recorded_videos) ?>)
                                </h6>
                                <div class="row g-3">
                                    <?php foreach ($recorded_videos as $index => $video): 
                                        $video_path = !empty($video['smv_video_url']) ? trim($video['smv_video_url']) : '';
                                        
                                        // Handle video URL - EXACT same as admin side (line 12487)
                                        if (!empty($video_path)) {
                                            // Check if it's a Vimeo ID (numeric)
                                            if (is_numeric($video_path)) {
                                                $video_url = 'https://player.vimeo.com/video/' . $video_path;
                                                $is_vimeo = true;
                                                $video_type = 'video/mp4';
                                            } 
                                            // Check if it's already a full URL
                                            elseif (strpos($video_path, 'http') === 0) {
                                                $video_url = $video_path;
                                                $is_vimeo = (strpos($video_path, 'vimeo.com') !== false);
                                                $video_type = 'video/mp4';
                                            } 
                                            // Local file path - EXACT same as admin side
                                            else {
                                                // Remove leading slash if exists
                                                $video_path = ltrim($video_path, '/');
                                                $video_url = base_url($video_path);
                                                $is_vimeo = false;
                                                
                                                // Detect video type from extension
                                                $video_ext = strtolower(pathinfo($video_path, PATHINFO_EXTENSION));
                                                $video_type = 'video/mp4'; // default
                                                if ($video_ext == 'webm') {
                                                    $video_type = 'video/webm';
                                                } elseif ($video_ext == 'ogg' || $video_ext == 'ogv') {
                                                    $video_type = 'video/ogg';
                                                } elseif ($video_ext == 'mov') {
                                                    $video_type = 'video/quicktime';
                                                } elseif ($video_ext == 'mp4') {
                                                    $video_type = 'video/mp4';
                                                }
                                            }
                                        } else {
                                            $video_url = '';
                                            $is_vimeo = false;
                                            $video_type = 'video/mp4';
                                        }
                                        
                                        // Debug: Show video URL (remove after testing)
                                        // echo "<!-- Debug: Video Path: $video_path, Video URL: $video_url, Type: $video_type -->";
                                    ?>
                                        <div class="col-12">
                                            <div class="card recorded-video-card border" style="border-radius: 8px; overflow: hidden;">
                                                <?php if ($is_vimeo): ?>
                                                    <!-- Vimeo Embed -->
                                                    <div class="video-thumbnail-wrapper" style="position: relative; padding-bottom: 56.25%; background: #000;">
                                                        <iframe id="video-detail-<?= $index ?>" 
                                                                src="<?= $video_url ?>?autoplay=0&title=0&byline=0&portrait=0" 
                                                                style="position: absolute; top: 0; left: 0; width: 100%; height: 100%;" 
                                                                frameborder="0" 
                                                                allow="autoplay; fullscreen; picture-in-picture" 
                                                                allowfullscreen>
                                                        </iframe>
                                                    </div>
                                                <?php else: ?>
                                                    <!-- Local Video - With Modal -->
                                                    <div class="video-thumbnail-wrapper" style="position: relative; padding-bottom: 56.25%; background: #000; cursor: pointer;" onclick="openVideoModal(<?= $index ?>)">
                                                        <div style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; display: flex; align-items: center; justify-content: center; background: linear-gradient(135deg, #098FD9, #0B8CD4);">
                                                            <i class="fas fa-play-circle" style="font-size: 64px; color: white; opacity: 0.9;"></i>
                                                        </div>
                                                        <?php if (!empty($video['live_class_title'])): ?>
                                                            <span class="badge" style="position: absolute; top: 10px; right: 10px; background: rgba(9, 143, 217, 0.9); color: white; padding: 5px 10px; border-radius: 4px; font-size: 11px; z-index: 10;">
                                                                <i class="fas fa-chalkboard-teacher"></i> Live Class
                                                            </span>
                                                        <?php endif; ?>
                                                    </div>
                                                    
                                                    <!-- Video Modal - Simple without Bootstrap dependency -->
                                                    <div class="modal fade" id="videoModal<?= $index ?>" tabindex="-1" style="display: none; position: fixed; top: 0; left: 0; z-index: 1050; width: 100%; height: 100%; overflow: hidden; outline: 0;">
                                                        <div style="position: relative; width: 90%; max-width: 900px; margin: 50px auto; pointer-events: none;">
                                                            <div class="modal-content" style="position: relative; display: flex; flex-direction: column; width: 100%; pointer-events: auto; background-color: #000; background-clip: padding-box; border: none; border-radius: 8px; outline: 0;">
                                                                <div class="modal-header" style="display: flex; align-items: flex-start; justify-content: space-between; padding: 1rem; border-bottom: 1px solid #333; border-top-left-radius: 8px; border-top-right-radius: 8px;">
                                                                    <h5 class="modal-title text-white" style="margin: 0; line-height: 1.5;">
                                                                        <?= htmlspecialchars($video['smv_title']) ?>
                                                                    </h5>
                                                                    <button type="button" class="btn-close" onclick="closeVideoModal(<?= $index ?>)" style="padding: 0.5rem; margin: -0.5rem -0.5rem -0.5rem auto; background: transparent; border: 0; font-size: 1.5rem; font-weight: 700; line-height: 1; color: #fff; text-shadow: 0 1px 0 #fff; opacity: 0.5; cursor: pointer;">&times;</button>
                                                                </div>
                                                                <div class="modal-body p-0" style="position: relative; padding: 0; flex: 1 1 auto; background: #000;">
                                                                    <div style="position: relative; padding-bottom: 56.25%; background: #000;">
                                                                        <video id="modal-video-<?= $index ?>" 
                                                                               style="position: absolute; top: 0; left: 0; width: 100%; height: 100%;" 
                                                                               controls 
                                                                               preload="metadata"
                                                                               playsinline
                                                                               webkit-playsinline>
                                                                            <source src="<?= htmlspecialchars($video_url) ?>" type="<?= htmlspecialchars($video_type) ?>">
                                                                            <source src="<?= htmlspecialchars($video_url) ?>" type="video/mp4">
                                                                            Your browser does not support the video tag.
                                                                        </video>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                                </div>
                                                <div class="card-body p-3">
                                                    <h6 class="card-title mb-2" style="font-size: 16px; font-weight: 600; color: #333;">
                                                        <?= htmlspecialchars($video['smv_title']) ?>
                                                    </h6>
                                                    <?php if (!empty($video['smv_description'])): ?>
                                                        <p class="card-text text-muted small mb-2">
                                                            <?= nl2br(htmlspecialchars($video['smv_description'])) ?>
                                                        </p>
                                                    <?php endif; ?>
                                                    <button type="button" class="btn btn-primary btn-sm w-100" onclick="openVideoModal(<?= $index ?>)">
                                                        <i class="fas fa-play me-1"></i> View Video
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        <?php else: ?>
                            <div class="alert alert-info text-center">
                                <i class="fas fa-info-circle me-2"></i>
                                No recorded videos available for this item.
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
// Open video modal - Simple approach without Bootstrap dependency
function openVideoModal(index) {
    const modalId = 'videoModal' + index;
    const modal = document.getElementById(modalId);
    
    if (!modal) {
        console.error('Modal not found:', modalId);
        return;
    }
    
    // Show modal
    modal.style.display = 'block';
    modal.classList.add('show');
    document.body.classList.add('modal-open');
    
    // Add backdrop
    let backdrop = document.getElementById('modal-backdrop');
    if (!backdrop) {
        backdrop = document.createElement('div');
        backdrop.id = 'modal-backdrop';
        backdrop.className = 'modal-backdrop fade show';
        backdrop.style.cssText = 'position: fixed; top: 0; left: 0; z-index: 1040; width: 100vw; height: 100vh; background-color: #000; opacity: 0.5;';
        backdrop.onclick = function() { closeVideoModal(index); };
        document.body.appendChild(backdrop);
    }
    
    // Play video
    setTimeout(function() {
        const video = document.getElementById('modal-video-' + index);
        if (video) {
            video.play().catch(function(error) {
                console.log('Auto-play prevented:', error);
            });
        }
    }, 300);
}

// Close video modal and pause video
function closeVideoModal(index) {
    const modalId = 'videoModal' + index;
    const modal = document.getElementById(modalId);
    
    if (modal) {
        modal.style.display = 'none';
        modal.classList.remove('show');
        document.body.classList.remove('modal-open');
    }
    
    // Remove backdrop
    const backdrop = document.getElementById('modal-backdrop');
    if (backdrop) {
        backdrop.remove();
    }
    
    // Pause video
    const video = document.getElementById('modal-video-' + index);
    if (video) {
        video.pause();
        video.currentTime = 0;
    }
}

// Close modal on backdrop click
document.addEventListener('click', function(e) {
    if (e.target && e.target.id === 'modal-backdrop') {
        const modals = document.querySelectorAll('.modal.show');
        modals.forEach(function(modal) {
            const index = modal.id.replace('videoModal', '');
            closeVideoModal(index);
        });
    }
});

// Pause all other videos when one is played
document.addEventListener('play', function(e) {
    const videos = document.getElementsByTagName('video');
    for (let i = 0; i < videos.length; i++) {
        if (videos[i] != e.target) {
            videos[i].pause();
        }
    }
}, true);
</script>

<style>
.info-box {
    border-left: 4px solid #0B8CD4;
}

.recorded-video-card {
    transition: transform 0.3s, box-shadow 0.3s;
}

.recorded-video-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 4px 12px rgba(9, 143, 217, 0.2);
}

.video-thumbnail-wrapper:hover .video-placeholder-detail {
    opacity: 0.8;
}
</style>

