<section class="py-5" style="background: #f5f7fa; min-height: 60vh; margin-bottom: 100px; margin-top: 20px;">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="card shadow-lg border-0">
                    <div class="card-header bg-primary text-white py-4">
                        <h4 class="mb-0"><i class="fas fa-video me-2"></i>Recorded Videos</h4>
                        <p class="mb-0 text-white-50 small">Study Materials and Live Classes with Recorded Videos</p>
                    </div>
                    <div class="card-body p-4">
                        <?php 
                        // Debug info (remove after testing)
                        if (isset($debug_all_videos_count)) {
                            echo "<!-- Debug: All videos found: " . $debug_all_videos_count . " -->";
                            echo "<!-- Debug: SM IDs: " . implode(',', $debug_sm_ids ?? []) . " -->";
                            echo "<!-- Debug: Final items: " . count($video_items) . " -->";
                        }
                        ?>
                        <?php if (!empty($all_videos)): ?>
                            <div class="row g-4">
                                <?php foreach ($all_videos as $index => $video): 
                                    $video_path = !empty($video['smv_video_url']) ? trim($video['smv_video_url']) : '';
                                    
                                    // Handle video URL
                                    if (!empty($video_path)) {
                                        if (is_numeric($video_path)) {
                                            $video_url = 'https://player.vimeo.com/video/' . $video_path;
                                            $is_vimeo = true;
                                            $video_type = 'video/mp4';
                                        } elseif (strpos($video_path, 'http') === 0) {
                                            $video_url = $video_path;
                                            $is_vimeo = (strpos($video_path, 'vimeo.com') !== false);
                                            $video_type = 'video/mp4';
                                        } else {
                                            $video_path = ltrim($video_path, '/');
                                            $video_url = base_url($video_path);
                                            $is_vimeo = false;
                                            
                                            $video_ext = strtolower(pathinfo($video_path, PATHINFO_EXTENSION));
                                            $video_type = 'video/mp4';
                                            if ($video_ext == 'webm') {
                                                $video_type = 'video/webm';
                                            } elseif ($video_ext == 'ogg' || $video_ext == 'ogv') {
                                                $video_type = 'video/ogg';
                                            } elseif ($video_ext == 'mov') {
                                                $video_type = 'video/quicktime';
                                            }
                                        }
                                    } else {
                                        $video_url = '';
                                        $is_vimeo = false;
                                        $video_type = 'video/mp4';
                                    }
                                ?>
                                    <div class="col-md-6 col-lg-4">
                                        <div class="card h-100" style="border: 1px solid #e0e0e0; border-radius: 8px; overflow: hidden;">
                                            <div class="video-thumbnail-wrapper" style="position: relative; padding-bottom: 56.25%; background: #000; cursor: pointer;" onclick="openVideoModal(<?= $index ?>)">
                                                <div style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; display: flex; align-items: center; justify-content: center; background: linear-gradient(135deg, #098FD9, #0B8CD4);">
                                                    <i class="fas fa-play-circle" style="font-size: 48px; color: white; opacity: 0.9;"></i>
                                                </div>
                                                <?php if (!empty($video['lc_title'])): ?>
                                                    <span class="badge" style="position: absolute; top: 10px; right: 10px; background: rgba(9, 143, 217, 0.9); color: white; padding: 5px 10px; border-radius: 4px; font-size: 11px; z-index: 10;">
                                                        <i class="fas fa-chalkboard-teacher"></i> Live Class
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                            
                                            <!-- Video Modal -->
                                            <div class="modal fade" id="videoModal<?= $index ?>" tabindex="-1" style="display: none; position: fixed; top: 0; left: 0; z-index: 1050; width: 100%; height: 100%; overflow: hidden; outline: 0;">
                                                <div style="position: relative; width: 90%; max-width: 900px; margin: 50px auto; pointer-events: none;">
                                                    <div class="modal-content" style="position: relative; display: flex; flex-direction: column; width: 100%; pointer-events: auto; background-color: #000; background-clip: padding-box; border: none; border-radius: 8px; outline: 0;">
                                                        <div class="modal-header" style="display: flex; align-items: flex-start; justify-content: space-between; padding: 1rem; border-bottom: 1px solid #333; border-top-left-radius: 8px; border-top-right-radius: 8px;">
                                                            <h5 class="modal-title text-white" style="margin: 0; line-height: 1.5;">
                                                                <?= htmlspecialchars($video['smv_title']) ?>
                                                            </h5>
                                                            <button type="button" class="btn-close" onclick="closeVideoModal(<?= $index ?>)" style="padding: 0.5rem; margin: -0.5rem -0.5rem -0.5rem auto; background: transparent; border: 0; font-size: 1.5rem; font-weight: 700; line-height: 1; color: #fff; text-shadow: 0 1px 0 #fff; opacity: 0.5; cursor: pointer;">&times;</button>
                                                        </div>
                                                        <div class="modal-body p-0" style="position: relative; padding: 0; flex: 1 1 auto; background: #000;">
                                                            <div style="position: relative; padding-bottom: 56.25%; background: #000;">
                                                                <?php if ($is_vimeo): ?>
                                                                    <iframe src="<?= htmlspecialchars($video_url) ?>?autoplay=0&title=0&byline=0&portrait=0" 
                                                                            style="position: absolute; top: 0; left: 0; width: 100%; height: 100%;" 
                                                                            frameborder="0" 
                                                                            allow="autoplay; fullscreen; picture-in-picture" 
                                                                            allowfullscreen>
                                                                    </iframe>
                                                                <?php else: ?>
                                                                    <video id="modal-video-<?= $index ?>" 
                                                                           style="position: absolute; top: 0; left: 0; width: 100%; height: 100%;" 
                                                                           controls 
                                                                           preload="metadata"
                                                                           playsinline
                                                                           webkit-playsinline>
                                                                        <source src="<?= htmlspecialchars($video_url) ?>" type="<?= htmlspecialchars($video_type) ?>">
                                                                        <source src="<?= htmlspecialchars($video_url) ?>" type="video/mp4">
                                                                        Your browser does not support the video tag.
                                                                    </video>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="card-body p-3">
                                                <h6 class="card-title mb-2" style="font-size: 14px; font-weight: 600; color: #333;">
                                                    <?= htmlspecialchars($video['smv_title']) ?>
                                                </h6>
                                                <?php if (!empty($video['smv_description'])): ?>
                                                    <p class="card-text text-muted small mb-2" style="display: -webkit-box; -webkit-line-clamp: 2; -webkit-box-orient: vertical; overflow: hidden;">
                                                        <?= htmlspecialchars(strip_tags($video['smv_description'])) ?>
                                                    </p>
                                                <?php endif; ?>
                                                <?php if (!empty($video['sm_name'])): ?>
                                                    <p class="text-muted small mb-0">
                                                        <i class="fas fa-book me-1"></i> <?= htmlspecialchars($video['sm_name']) ?>
                                                    </p>
                                                <?php endif; ?>
                                                <button type="button" class="btn btn-primary btn-sm w-100 mt-2" onclick="openVideoModal(<?= $index ?>)">
                                                    <i class="fas fa-play me-1"></i> View Video
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php else: ?>
                            <div class="text-center py-5">
                                <i class="fas fa-video-slash" style="font-size: 64px; color: #ccc; margin-bottom: 20px;"></i>
                                <h5 class="text-muted">No Recorded Videos Available</h5>
                                <p class="text-muted">You don't have any study materials or live classes with recorded videos yet.</p>
                                <a href="<?= base_url('profile') ?>" class="btn btn-outline-primary mt-3">
                                    <i class="fas fa-arrow-left me-2"></i> Back to Profile
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
.recorded-video-item-card {
    transition: transform 0.3s, box-shadow 0.3s;
}

.recorded-video-item-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 4px 12px rgba(9, 143, 217, 0.2);
}

.video-icon-wrapper {
    transition: transform 0.3s;
}

.recorded-video-item-card:hover .video-icon-wrapper {
    transform: scale(1.1);
}
</style>

<script>
// Open video modal
function openVideoModal(index) {
    const modalId = 'videoModal' + index;
    const modal = document.getElementById(modalId);
    
    if (!modal) {
        console.error('Modal not found:', modalId);
        return;
    }
    
    modal.style.display = 'block';
    modal.classList.add('show');
    document.body.classList.add('modal-open');
    
    let backdrop = document.getElementById('modal-backdrop');
    if (!backdrop) {
        backdrop = document.createElement('div');
        backdrop.id = 'modal-backdrop';
        backdrop.className = 'modal-backdrop fade show';
        backdrop.style.cssText = 'position: fixed; top: 0; left: 0; z-index: 1040; width: 100vw; height: 100vh; background-color: #000; opacity: 0.5;';
        backdrop.onclick = function() { closeVideoModal(index); };
        document.body.appendChild(backdrop);
    }
    
    setTimeout(function() {
        const video = document.getElementById('modal-video-' + index);
        if (video) {
            video.play().catch(function(error) {
                console.log('Auto-play prevented:', error);
            });
        }
    }, 300);
}

function closeVideoModal(index) {
    const modalId = 'videoModal' + index;
    const modal = document.getElementById(modalId);
    
    if (modal) {
        modal.style.display = 'none';
        modal.classList.remove('show');
        document.body.classList.remove('modal-open');
    }
    
    const backdrop = document.getElementById('modal-backdrop');
    if (backdrop) {
        backdrop.remove();
    }
    
    const video = document.getElementById('modal-video-' + index);
    if (video) {
        video.pause();
        video.currentTime = 0;
    }
}
</script>

