<script>
// CRITICAL: Run this BEFORE nice-select loads to prevent it from running on our dropdown
(function() {
	if (typeof jQuery === 'undefined') {
		var checkJQuery = setInterval(function() {
			if (typeof jQuery !== 'undefined') {
				clearInterval(checkJQuery);
				preventNiceSelect();
			}
		}, 50);
	} else {
		preventNiceSelect();
	}
	
	function preventNiceSelect() {
		var $ = jQuery;
		
		// Override niceSelect BEFORE main.js runs
		if ($.fn.niceSelect) {
			var original = $.fn.niceSelect;
			$.fn.niceSelect = function() {
				if (this.attr('id') === 'categorySelect' || this.hasClass('no-nice-select')) {
					return this;
				}
				return original.apply(this, arguments);
			};
		}
	}
})();
</script>

<style>
	/* =========================
	General Card Styles
	========================= */
	.course-card {
		background: #fff;
		border-radius: 18px;
		box-shadow: 0 10px 30px #4C579A;
		transition: all 0.4s ease;
		display: flex;
		flex-direction: column;
		padding: 22px;
		height: 100%;
	}

	.course-card:hover {
		transform: translateY(-12px);
		box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
	}

	.course-card img {
		width: 100%;
		height: 200px;
		object-fit: cover;
		border-radius: 14px;
		margin-bottom: 18px;
		transition: transform 0.4s ease;
	}

	.course-card:hover img {
		transform: scale(1.05);
	}

	/* Title & Description */
	.course-card h5 {
		font-size: 1.3rem;
		font-weight: 600;
		margin-bottom: 10px;
		color: #221759;
	}

	.course-card p {
		flex-grow: 1;
		font-size: 0.9rem;
		color: #555;
		margin-bottom: 14px;
	}

	/* Meta info */
	.course-meta {
		display: flex;
		justify-content: space-between;
		align-items: center;
		flex-wrap: wrap;
		margin-bottom: 12px;
	}

	.course-meta span {
		font-size: 0.875rem;
		font-weight: 500;
		color: #221759;
	}

	.course-meta .badge {
		background: #E3F2FD;
		color: #221759;
		padding: 6px 12px;
		border-radius: 10px;
		font-size: 0.8rem;
		margin-right: 6px;
	}

	/* Star Rating */
	.stars i {
		margin-right: 2px;
		font-size: 0.9rem;
	}

	/* View Button */
	.course-card .btn {
		align-self: flex-start;
		padding: 10px 20px;
		font-size: 0.9rem;
		background: linear-gradient(135deg, #0B8CD4, rgba(37, 21, 107, 0.76));
		color: #fff;
		border: none;
		border-radius: 12px;
		transition: all 0.3s;
	}

	.course-card .btn:hover {
		background: linear-gradient(135deg, #0B8CD4, rgba(37, 21, 107, 0.76));
		transform: translateY(-2px);
	}

	/* Sidebar */
	.course__sidebar {
		background: #fff;
		border-radius: 18px;
		padding: 28px 22px;
		box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
		transition: all 0.3s;
		overflow: visible !important;
	}
	
	/* Ensure parent containers don't clip dropdown */
	.course__sidebar form,
	.course__sidebar .mb-4,
	.course__sidebar .category-dropdown-wrapper {
		overflow: visible !important;
		position: relative;
	}

	.course__sidebar input.form-control {
		padding: 12px 14px;
		border-radius: 12px;
		border: 1px solid #ddd;
		box-shadow: 0 2px 6px rgba(0, 0, 0, 0.05);
		transition: all 0.3s;
	}

	.course__sidebar input.form-control:focus {
		border-color: #0B8CD4;
		box-shadow: 0 3px 10px rgba(11, 140, 212, 0.2);
	}

	/* Buttons inside sidebar */
	.course__sidebar .btn-primary {
		border-radius: 12px;
		padding: 12px 0;
		font-weight: 500;
		background: linear-gradient(135deg, #0B8CD4, rgba(37, 21, 107, 0.76));
		border: none;
		transition: all 0.3s;
	}

	.course__sidebar .btn-primary:hover {
		background: linear-gradient(135deg, #0B8CD4, rgba(37, 21, 107, 0.76));
	}
	
	/* Category Dropdown Styling - Modern Look matching reference */
	.category-dropdown-wrapper {
		position: relative;
		width: 100%;
		display: block;
		overflow: visible;
	}
	
	/* Label styling for category dropdown */

	
	.category-dropdown {
		font-size: 0.95rem !important;
		color: #221759 !important;
		width: 100% !important;
		min-width: 100% !important;
		max-width: 100% !important;
		background-color: #fff !important;
		border: 1px solid #ddd !important;
		border-radius: 8px !important;
		padding: 12px 40px 12px 14px !important;
		cursor: pointer !important;
		transition: all 0.3s ease;
		box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05) !important;
		appearance: none !important;
		-webkit-appearance: none !important;
		-moz-appearance: none !important;
		background-image: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12"><path fill="%23666" d="M6 9L1 4h10z"/></svg>') !important;
		background-repeat: no-repeat !important;
		background-position: right 14px center !important;
		background-size: 12px 12px !important;
		position: relative !important;
		z-index: 10 !important;
		display: block !important;
		box-sizing: border-box !important;
		margin: 0 !important;
		line-height: 1.5 !important;
		height: auto !important;
		overflow: visible !important;
	}
	
	/* Ensure correct wrapper is visible */
	#categoryFilterWrapper {
		display: block !important;
	}
	
	/* Hide ALL other mb-4 divs that contain categorySelect */
	.course__sidebar .mb-4:not(#categoryFilterWrapper) {
		position: relative;
	}
	
	.course__sidebar .mb-4:not(#categoryFilterWrapper) select#categorySelect,
	.course__sidebar .mb-4:not(#categoryFilterWrapper) select.category-dropdown {
		display: none !important;
		visibility: hidden !important;
		height: 0 !important;
		width: 0 !important;
		opacity: 0 !important;
		position: absolute !important;
		left: -9999px !important;
	}
	
	/* Hide entire duplicate wrapper divs */
	.course__sidebar .mb-4:not(#categoryFilterWrapper):has(select#categorySelect),
	.course__sidebar .mb-4:not(#categoryFilterWrapper):has(.nice-select.category-dropdown) {
		display: none !important;
		height: 0 !important;
		overflow: hidden !important;
		margin: 0 !important;
		padding: 0 !important;
	}
	
	/* Hide ALL nice-select duplicates - CSS only solution */
	.course__sidebar .nice-select.category-dropdown {
		display: none !important;
	}
	
	/* Show ONLY the one inside categoryFilterWrapper */
	#categoryFilterWrapper .nice-select.category-dropdown {
		display: block !important;
		visibility: visible !important;
		opacity: 1 !important;
		height: auto !important;
		width: 100% !important;
	}
	
	/* Hide any duplicate nice-selects outside the wrapper */
	.course__sidebar .mb-4:not(#categoryFilterWrapper) .nice-select.category-dropdown {
		display: none !important;
		visibility: hidden !important;
		height: 0 !important;
		width: 0 !important;
		opacity: 0 !important;
		position: absolute !important;
		left: -9999px !important;
		pointer-events: none !important;
	}
	
	.category-dropdown:hover {
		border-color: #999 !important;
		box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1) !important;
		background-color: #fff !important;
	}
	
	.category-dropdown:focus {
		border-color: #0B8CD4 !important;
		box-shadow: 0 3px 12px rgba(11, 140, 212, 0.25) !important;
		outline: none !important;
		background-color: #fff !important;
	}
	
	.category-dropdown:active {
		background-color: #fff !important;
		border-color: #0B8CD4 !important;
	}
	
	/* Fix option styling - ensure proper width, colors, and no truncation */
	.category-dropdown option {
		padding: 10px 14px !important;
		background-color: #fff !important;
		color: #221759 !important;
		white-space: normal !important;
		word-wrap: break-word !important;
		overflow: visible !important;
		text-overflow: clip !important;
		display: block !important;
		min-height: auto !important;
		line-height: 1.5 !important;
	}
	
	/* Selected option styling */
	.category-dropdown option:checked,
	.category-dropdown option[selected] {
		background-color: #0B8CD4 !important;
		color: #fff !important;
	}
	
	/* Prevent any inherited styles from interfering */
	.course__sidebar .category-dropdown,
	.course__sidebar .category-dropdown option {
		font-family: inherit !important;
		font-size: 0.95rem !important;
	}
	
	/* Override any Bootstrap form-control styles that might interfere */
	.category-dropdown.form-control,
	select.category-dropdown {
		background-color: #fff !important;
		border: 1px solid #ddd !important;
	}

	/* Responsive Adjustments */
	@media (max-width: 992px) {
		.course-card img {
			height: 180px;
		}

		.course-card h5 {
			font-size: 1.2rem;
		}
	}

	@media (max-width: 768px) {

		.col-lg-4,
		.col-lg-8 {
			order: unset !important;
		}

		.course-card img {
			height: 160px;
		}
	}

	@media (max-width: 576px) {
		.course-card img {
			height: 140px;
		}

		.course-card h5 {
			font-size: 1rem;
		}

		.course-card p {
			font-size: 0.85rem;
		}

		.course-meta span {
			font-size: 0.8rem;
		}
	}

	.banner-wrapper {
		height: 100px;
		background-size: cover;
		background-position: center;
		display: flex;
		align-items: center;
		justify-content: center;
		text-align: center;
	}

	.banner-title {
		color: #0A8FD6;
		display: inline-block;
		background: #E8F6FE;
		padding: 15px 25px;
		border-radius: 8px;
		font-size: 2rem;
		max-width: 90%;
		word-wrap: break-word;
	}
</style>

<?php
// Load banner helper
$this->load->helper('banner');

// Get search query or default title
$search_title = isset($_GET['q']) && !empty($_GET['q']) ? 'Search Results for: ' . htmlspecialchars($_GET['q']) : 'Study Material';


// Try to get dynamic banner for search page
$banner_html = display_page_banner('search', $search_title, false);

if (!empty($banner_html)) {
    echo $banner_html;
} else {
    // Fallback banner
    ?>
    <div class="banner-wrapper">
        <h1 class="banner-title"><?= $search_title ?></h1>
    </div>
    <?php
}
?>

<section style="padding: 60px 0; margin-bottom: 20px;">
	<div class="container">
		<div class="row gy-4">

			<!-- Sidebar Filters -->
			<div class="col-lg-4 order-1 order-lg-2">
				<form action="<?= base_url('action/smart_search') ?>" method="get">
					<aside class="course__sidebar px-lg-4 px-0">
						<!-- Search Box -->
						<div class="mb-4 position-relative">
							<input type="text" name="q" value="<?= @$_GET['q'] ?>" class="form-control" placeholder="Search for courses...">
							<button type="submit" class="btn position-absolute end-0 top-0 mt-1 me-2 text-muted">🔍</button>
						</div>

						<!-- Categories Filter Dropdown - SINGLE INSTANCE ONLY -->
						<?php
						// Get categories that have courses (from database, not session)
						$selected_cat = isset($_GET['cat']) && !empty($_GET['cat']) ? $_GET['cat'] : '';
						
						// Get categories that actually have courses assigned
						$categories_query = $this->db->query("
							SELECT DISTINCT c.ctid, c.name, c.sid 
							FROM yn_site_catagory c
							INNER JOIN x_edu_courses co ON co.course_cat = c.ctid
							WHERE co.course_status = '1'
							ORDER BY c.sid ASC
						");
						$categories = $categories_query->result_array();
						if (!empty($categories)): ?>
							<div class="mb-4" id="categoryFilterWrapper">
								<label for="categorySelect" class="fw-bold mb-2 d-block">Category</label>
								<select name="cat" id="categorySelect" class="category-dropdown no-nice-select" style="width: 100%;">
									<option value="">All Categories</option>
									<?php foreach ($categories as $category): ?>
										<option value="<?= $category['ctid'] ?>" <?= ($selected_cat == $category['ctid']) ? 'selected' : '' ?>>
											<?= htmlspecialchars($category['name']) ?>
										</option>
									<?php endforeach; ?>
								</select>
							</div>
						<?php endif; ?>

						<!-- Price Filter -->


						<div class="mb-4">
							<button type="submit" class="btn btn-primary w-100">Search</button>
						</div>
					</aside>
				</form>
			</div>

			<!-- Course Grid -->
			<div class="col-lg-8 order-2 order-lg-1">
				<div class="row g-4">
					<?php
					if (count($show_courses) == 0) {
						echo '<div class="col-12 text-center mb-4"><p class="text-danger fw-semibold">No courses found. Showing latest courses...</p></div>';
						$allcourses = $this->db->query("SELECT * FROM x_edu_courses WHERE course_status='1' ORDER BY course_id DESC LIMIT 10");
						$show_courses = $allcourses->result_array();
					}

					foreach ($show_courses as $thecourse):
						$thecourse_url = base_url('course_detail/') . $thecourse['course_id'] . '/' . url_smart($thecourse['course_name']);
					?>
						<div class="col-md-6 col-lg-4"> <!-- 3 cards per row on large screens -->
							<a href="<?= $thecourse_url ?>" class="text-decoration-none" style="color: inherit;">
								<div class="course-card">
									<img src="<?= base_url('assets/avator/upload/courses/' . $thecourse['course_img']) ?>" alt="<?= $thecourse['course_name'] ?>">
									
									<div class="course-meta mb-2">
										<!-- <span class="badge">Category: <?= $thecourse['course_cat'] ?? '-' ?></span> -->
										<span class="badge">Lessons: <?= $thecourse['course_lessons'] ?? '0' ?></span>
									</div>

									<div class="course-meta mb-2">
										<span class="badge"><?= $thecourse['course_price'] > 0 ? '₹' . $thecourse['course_price'] : 'Free' ?></span>
										<span class="stars">
											<?php for ($i = 1; $i <= 5; $i++): ?>
												<i class="fas fa-star" style="color:<?= $i <= $thecourse['course_rating'] ? '#FFD700' : '#ccc' ?>;"></i>
											<?php endfor; ?>
										</span>
									</div>

									<h5><?= $thecourse['course_name'] ?></h5>
									<p><?= substr(strip_tags($thecourse['course_desc']), 0, 50) ?>...</p>
									<a href="<?= $thecourse_url ?>" class="btn btn-primary mt-auto">View Course</a>
								</div>
							</a>
						</div>
					<?php endforeach; ?>
				</div>

			</div>

		</div>
	</div>
</section>

<script>
// Prevent nice-select from running on our dropdown and remove any duplicates
(function() {
	// Wait for jQuery to load
	if (typeof jQuery === 'undefined') {
		var checkJQuery = setInterval(function() {
			if (typeof jQuery !== 'undefined') {
				clearInterval(checkJQuery);
				init();
			}
		}, 100);
	} else {
		init();
	}
	
	function init() {
		var $ = jQuery;
		
		// Override niceSelect BEFORE main.js runs
		var originalNiceSelect = $.fn.niceSelect;
		
		$.fn.niceSelect = function() {
			// Skip our category select - don't run nice-select on it
			if (this.attr('id') === 'categorySelect' || this.hasClass('no-nice-select')) {
				return this;
			}
			// For all other selects, use original behavior
			return originalNiceSelect.apply(this, arguments);
		};
		
		// Remove any existing nice-select instances on our dropdown
		function cleanup() {
			var $select = $('#categorySelect');
			if ($select.length) {
				// Remove any nice-select divs created for this select
				$select.next('.nice-select').remove();
				$select.siblings('.nice-select').remove();
				
				// Remove duplicates
				var $all = $('.course__sidebar .nice-select.category-dropdown');
				if ($all.length > 1) {
					$all.slice(1).remove();
				}
				
				var $allSelects = $('.course__sidebar select#categorySelect');
				if ($allSelects.length > 1) {
					$allSelects.not($select).each(function() {
						$(this).closest('.mb-4').not('#categoryFilterWrapper').remove();
					});
				}
			}
		}
		
		$(document).ready(cleanup);
		setTimeout(cleanup, 100);
		setTimeout(cleanup, 500);
		setTimeout(cleanup, 1000);
	}
})();
</script>
