<style>
    .rating-line {
        margin-top: 8px;
        text-align: left;
    }

    .rating-line .star {
        font-size: 12px;
        color: #ffc107;
    }

    /* Shop Page - Same card design as home.php */
    /* Make rows use flexbox for equal height columns */
    .shop-products-row,
    .shop-default-wrapper .row:has(.shop-box-items) {
            display: flex !important;
        flex-wrap: wrap !important;
        align-items: stretch !important;
    }
    
    .shop-products-row > [class*="col-"],
    .shop-default-wrapper .row:has(.shop-box-items) > [class*="col-"] {
        padding-left: 12px !important;
        padding-right: 12px !important;
        display: flex !important;
        flex-direction: column !important;
    }

    /* Card container - use flexbox for consistent alignment */
    .shop-products-row .shop-box-items,
    .shop-default-wrapper .shop-box-items {
        padding: 0 !important;
        margin: 0 !important;
        width: 100% !important;
        height: 100% !important;
        overflow: hidden;
        border: none !important;
        box-sizing: border-box;
        display: flex !important;
        flex-direction: column !important;
    }

    /* Book thumb - completely flush, no padding, no border, no shadow */
    .shop-products-row .shop-box-items .book-thumb,
    .shop-default-wrapper .shop-box-items .book-thumb {
        padding: 0 !important;
        margin: 0 !important;
        width: 100% !important;
        min-height: 239px !important;
        height: auto !important;
        border: none !important;
        border-radius: 0 !important;
        overflow: visible !important;
        display: block !important;
        box-sizing: border-box;
        box-shadow: none !important;
        background-color: transparent !important;
        position: relative;
        flex-shrink: 0 !important;
    }

    /* Link wrapper - full width and height */
    .shop-products-row .shop-box-items .book-thumb a,
    .shop-default-wrapper .shop-box-items .book-thumb a {
        display: block !important;
        width: 100% !important;
        height: 100% !important;
        padding: 0 !important;
        margin: 0 !important;
        }

    /* Image - 100% width to match text, with contain to show full image without cutting */
    .shop-products-row .shop-box-items .book-thumb img,
    .shop-default-wrapper .shop-box-items .book-thumb img {
        width: 100% !important;
            max-width: 100% !important;
        min-width: 100% !important;
        height: auto !important;
            object-fit: contain !important;
        object-position: center !important;
        display: block !important;
        margin: 0 !important;
        padding: 0 !important;
        border-radius: 0 !important;
        border: none !important;
        box-sizing: border-box !important;
        }

    /* Wishlist button positioning */
    .shop-products-row .shop-box-items .book-thumb .wishlist-btn,
    .shop-default-wrapper .shop-box-items .book-thumb .wishlist-btn {
            position: absolute !important;
            top: 10px !important;
            right: 10px !important;
        z-index: 10 !important;
    }
    
    /* Card content area - consistent alignment */
    .shop-products-row .shop-box-items .shop-content,
    .shop-default-wrapper .shop-box-items .shop-content {
        padding: 15px !important;
        padding-top: 15px !important;
        margin: 0 !important;
        flex-shrink: 0 !important;
        display: flex !important;
        flex-direction: column !important;
        min-height: fit-content !important;
    }
    
    /* Category (p) - consistent spacing and alignment */
    .shop-products-row .shop-box-items .shop-content p,
    .shop-default-wrapper .shop-box-items .shop-content p {
        margin: 0 !important;
        margin-bottom: 5px !important;
        padding: 0 !important;
        line-height: 1.4 !important;
        min-height: 20px !important;
    }
    
    /* Title (h3) - consistent spacing and alignment */
    .shop-products-row .shop-box-items .shop-content h3,
    .shop-default-wrapper .shop-box-items .shop-content h3 {
        margin: 0 !important;
        margin-bottom: 8px !important;
        padding: 0 !important;
        line-height: 1.5 !important;
        min-height: 42px !important;
        display: flex !important;
        align-items: flex-start !important;
    }
    
    .shop-products-row .shop-box-items .shop-content h3 a,
    .shop-default-wrapper .shop-box-items .shop-content h3 a {
        display: block !important;
        line-height: 1.5 !important;
        word-wrap: break-word !important;
    }
    
    /* Price list - consistent spacing */
    .shop-products-row .shop-box-items .shop-content .price-list,
    .shop-default-wrapper .shop-box-items .shop-content .price-list {
        margin: 0 !important;
        margin-bottom: 8px !important;
        padding: 0 !important;
        min-height: 24px !important;
    }
    
    /* Author post - consistent spacing */
    .shop-products-row .shop-box-items .shop-content .author-post,
    .shop-default-wrapper .shop-box-items .shop-content .author-post {
        margin: 0 !important;
        margin-bottom: 8px !important;
        padding: 0 !important;
        min-height: 20px !important;
    }
    
    /* Rating line - consistent spacing */
    .shop-products-row .shop-box-items .shop-content .rating-line,
    .shop-default-wrapper .shop-box-items .shop-content .rating-line {
        margin: 0 !important;
        padding: 0 !important;
        min-height: 18px !important;
    }
    
    /* Push Buy Now button to bottom for consistent alignment */
    .shop-products-row .shop-box-items .shop-button,
    .shop-default-wrapper .shop-box-items .shop-button {
        padding: 0 15px 15px 15px !important;
        margin: 0 !important;
        margin-top: auto !important;
        flex-shrink: 0 !important;
    }

    /* Fallback for browsers that don't support :has() */
    @supports not selector(:has(*)) {
        .shop-default-wrapper .row > [class*="col-"] {
            padding-left: 12px !important;
            padding-right: 12px !important;
            display: flex !important;
            flex-direction: column !important;
        }
    }
</style><?php
        // Default values
        $category_banner = 'https://cdn.theatlantic.com/thumbor/5T-358hrx4dcsOlQKo024rmLHf4=/0x0:2000x1125/1600x900/media/img/mt/2023/07/books_picku_up_put_down_final/original.jpg';
        $category_name = 'Our Collections'; // Default

        // Check if category ID is passed via GET (?cate=)
        if (isset($_GET['cate']) && $_GET['cate'] != '') {
            $cat_id = $_GET['cate'];
            $cat_data = $this->db->query("SELECT name, banner FROM yn_site_catagory WHERE ctid = ?", [$cat_id])->row_array();
            if (!empty($cat_data)) {
                $category_name = $cat_data['name'];
                if (!empty($cat_data['banner'])) {
                    $category_banner = base_url('assets/avator/upload/' . $cat_data['banner']);
                }
            }
        }
        ?>

<div class="breadcrumb-wrapper bg-cover section-padding d-flex align-items-center justify-content-center text-center"
    id="breadcrumb-wrapper"
    style="background-image: url('<?= $category_banner ?>'); height: 250px; background-size: cover; background-position: center;">

    <h1 id="breadcrumb-title" style="
        color: #0A8FD6;           /* Heading text color */
        display: inline-block;
        background: #E8F6FE;      /* Heading background color only */
        padding: 15px 25px;
        border-radius: 8px;
        font-size: 2rem;
        max-width: 90%;
        word-wrap: break-word;
    ">
        <?= htmlspecialchars($category_name) ?>
    </h1>

</div>



<section class="shop-section fix section-padding" style="margin-bottom: 50px;">
    <div class="container">
        <div class="shop-default-wrapper">
            <div class="row">
                <!-- Sidebar Start -->
                <!-- Categories Sidebar -->
                <div class="col-12 col-lg-3 order-1 order-lg-1 wow fadeInUp" data-wow-delay=".3s">
                    <div class="main-sidebar mb-4 mb-lg-0 p-3 bg-white shadow-sm rounded">
                        <div class="single-sidebar-widget">
                            <div class="wid-title mb-3">
                                <h5 class="fw-bold text-dark">Categories</h5>
                            </div>
                            <!-- Category Tabs -->
                            <div class="categories-list">
                                <ul class="nav nav-pills mb-3 flex-row flex-nowrap overflow-auto" id="pills-tab" role="tablist" style="gap:0.5rem;">
                                    <?php
                                    $thecats = $this->db->query("SELECT * FROM yn_site_catagory ORDER BY sid ASC")->result_array();
                                    foreach ($thecats as $cat):
                                        $tabId = 'pills-' . url_smart($cat['name']);
                                    ?>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link px-3 py-2 rounded-pill" id="<?= $tabId ?>-tab" data-bs-toggle="pill"
                                                data-bs-target="#<?= $tabId ?>" type="button" role="tab"
                                                aria-controls="<?= $tabId ?>" aria-selected="false"
                                                data-name="<?= htmlspecialchars($cat['name']) ?>"
                                                data-cat-id="<?= $cat['ctid'] ?>"
                                                data-banner="<?= !empty($cat['banner']) ? base_url('assets/avator/upload/' . $cat['banner']) : '' ?>">
                                                <?= htmlspecialchars($cat['name']) ?>
                                            </button>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>

                            <script>
                                document.addEventListener('DOMContentLoaded', function() {
                                    const breadcrumbTitle = document.getElementById('breadcrumb-title');
                                    const breadcrumbWrapper = document.getElementById('breadcrumb-wrapper');

                                    document.querySelectorAll('.nav-link[data-bs-toggle="pill"]').forEach(tab => {
                                        tab.addEventListener('shown.bs.tab', function(e) {
                                            const catName = e.target.getAttribute('data-name');
                                            const catBanner = e.target.getAttribute('data-banner');
                                            const catId = e.target.getAttribute('data-cat-id');

                                            // Update breadcrumb heading
                                            breadcrumbTitle.textContent = catName;

                                            // Update background dynamically, keep heading background color intact
                                            if (catBanner) {
                                                breadcrumbWrapper.style.backgroundImage = `url('${catBanner}')`;
                                            } else {
                                                breadcrumbWrapper.style.backgroundImage = 'none';
                                                breadcrumbWrapper.style.backgroundColor = '#E8F6FE';
                                            }
                                            
                            // Load subcategories for this category
                            if (catId) {
                                loadSubcategories(catId);
                            } else {
                                // Hide subcategories section if no category selected
                                document.getElementById('subcategories-section').style.display = 'none';
                                            }
                                        });
                                    });
                                    
                                    // Load subcategories on page load if category is selected
                                    <?php if ($current_cat_id > 0): ?>
                                        loadSubcategories(<?= $current_cat_id ?>);
                                    <?php endif; ?>
                                });
                                
                                function loadSubcategories(categoryId) {
                                    // AJAX call to load subcategories
                                    fetch('<?= base_url('get_subcategories') ?>?cat_id=' + categoryId)
                                        .then(response => response.json())
                                        .then(data => {
                                            const subcatContainer = document.getElementById('subcategories-list');
                                            if (data.subcategories && data.subcategories.length > 0) {
                                                subcatContainer.innerHTML = '<ul class="list-unstyled">';
                                                data.subcategories.forEach(subcat => {
                                                    const isActive = new URLSearchParams(window.location.search).get('subcat') == subcat.sc_id ? 'active' : '';
                                                    subcatContainer.innerHTML += `
                                                        <li class="mb-2">
                                                            <a href="<?= base_url('shop') ?>?cate=${categoryId}&subcat=${subcat.sc_id}" 
                                                               class="text-decoration-none text-dark d-block px-2 py-1 rounded subcategory-link ${isActive}"
                                                               style="transition: all 0.3s;"
                                                               onclick="window.location.href='<?= base_url('shop') ?>?cate=${categoryId}&subcat=${subcat.sc_id}'; return false;">
                                                                ${subcat.sc_name}
                                                            </a>
                                                        </li>
                                                    `;
                                                });
                                                subcatContainer.innerHTML += '</ul>';
                                                document.getElementById('subcategories-section').style.display = 'block';
                                            } else {
                                                document.getElementById('subcategories-section').style.display = 'none';
                                            }
                                        })
                                        .catch(error => {
                                            console.error('Error loading subcategories:', error);
                                        });
                                }
                            </script>
                            
                            <?php
                            // Get current category ID and subcategory ID
                            $current_cat_id = isset($_GET['cate']) ? intval($_GET['cate']) : 0;
                            $current_subcat_id = isset($_GET['subcat']) ? intval($_GET['subcat']) : 0;
                            
                            // Fetch subcategories for current category if category is selected
                            $subcategories = [];
                            if ($current_cat_id > 0) {
                                $subcategories = $this->db->query("SELECT * FROM yn_site_sub_cat WHERE sc_ctid = ? ORDER BY sc_sort ASC", [$current_cat_id])->result_array();
                            }
                            ?>
                            
                            <!-- Subcategories Section -->
                            <div id="subcategories-section" class="single-sidebar-widget mt-4" style="display: <?= !empty($subcategories) ? 'block' : 'none' ?>;">
                                <div class="wid-title mb-3">
                                    <h6 class="fw-bold text-dark">Subcategories</h6>
                                </div>
                                <div id="subcategories-list">
                                    <?php if (!empty($subcategories)): ?>
                                        <ul class="list-unstyled">
                                            <?php foreach ($subcategories as $subcat): ?>
                                                <li class="mb-2">
                                                    <a href="<?= base_url('shop?cate=' . $current_cat_id . '&subcat=' . $subcat['sc_id']) ?>" 
                                                       class="text-decoration-none text-dark d-block px-2 py-1 rounded subcategory-link <?= ($current_subcat_id == $subcat['sc_id']) ? 'active' : '' ?>"
                                                       style="transition: all 0.3s; cursor: pointer;">
                                                        <?= htmlspecialchars($subcat['sc_name']) ?>
                                                    </a>
                                                </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Optional Custom CSS -->
                <style>
                    /* Scrollable pills on mobile */
                    @media (max-width: 991px) {
                        .categories-list .nav-pills {
                            -webkit-overflow-scrolling: touch;
                        }

                        .categories-list .nav-link {
                            white-space: nowrap;
                            flex: 0 0 auto;
                        }
                    }

                    /* Active / hover effects */
                    .nav-pills .nav-link.active {
                        background-color: #ff6b6b;
                        color: #fff;
                    }

                    .nav-pills .nav-link {
                        border: 1px solid #ddd;
                        color: #555;
                        transition: all 0.3s;
                    }

                    .nav-pills .nav-link:hover {
                        background-color: #ff6b6b;
                        color: #fff;
                    }
                    
                    /* Subcategory styling */
                    .subcategory-link {
                        border: 1px solid #e0e0e0;
                        background-color: #f8f9fa;
                    }
                    
                    .subcategory-link:hover {
                        background-color: #0A8FD6;
                        color: #fff !important;
                        border-color: #0A8FD6;
                        transform: translateX(5px);
                    }
                    
                    .subcategory-link.active {
                        background-color: #0A8FD6;
                        color: #fff !important;
                        border-color: #0A8FD6;
                    }
                </style>

                <!-- Sidebar End -->

                <!-- Shop Products Area -->
                <div class="col-xl-9 col-lg-8 order-1 order-md-2">
                    <div class="tab-content" id="pills-tabContent">

                        <!-- All Products Tab -->
                        <div class="tab-pane fade show active" id="pills-all" role="tabpanel" aria-labelledby="pills-all-tab">
                            <div class="row shop-products-row g-2">
                                <?php
                                // Filter products by subcategory if selected, otherwise use controller data or fetch all
                                if ($current_subcat_id > 0) {
                                    $productsToShow = $this->db->query("SELECT * FROM yn_ecom_products WHERE p_sub_category = ? ORDER BY p_id DESC LIMIT 12", [$current_subcat_id])->result_array();
                                } elseif (!empty($prod)) {
                                    $productsToShow = $prod;
                                } else {
                                    $productsToShow = $this->db->query("SELECT * FROM yn_ecom_products ORDER BY p_id DESC LIMIT 12")->result_array();
                                }

                                if (empty($productsToShow)):
                                    $subcatName = '';
                                    if ($current_subcat_id > 0) {
                                        $subcatInfo = $this->db->query("SELECT sc_name FROM yn_site_sub_cat WHERE sc_id = ?", [$current_subcat_id])->row_array();
                                        $subcatName = !empty($subcatInfo['sc_name']) ? $subcatInfo['sc_name'] : '';
                                    }
                                ?>
                                    <div class="col-12">
                                        <div class="alert alert-info text-center" role="alert">
                                            <h5>No products found</h5>
                                            <?php if ($current_subcat_id > 0 && !empty($subcatName)): ?>
                                                <p>No products available in the subcategory "<?= htmlspecialchars($subcatName) ?>".</p>
                                            <?php else: ?>
                                                <p>No products available at the moment.</p>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php else:
                                foreach ($productsToShow as $pro):
                                    $url = base_url('product/' . $pro['p_id'] . '/' . url_smart($pro['p_name']));
                                    $catRow = $this->db->query("SELECT name FROM yn_site_catagory WHERE ctid=?", [$pro['p_category']])->row_array();
                                    $catName = !empty($catRow['name']) ? $catRow['name'] : 'General';
                                ?>

                                    <div class="col-6 col-md-4 col-lg-3 wow fadeInUp" data-wow-delay=".2s">
                                        <div class="shop-box-items">
                                            <div class="book-thumb center">
                                                <a href="<?= $url ?>">
                                                    <img src="<?= base_url('assets/avator/upload/' . $pro['p_cover']) ?>" alt="<?= htmlspecialchars($pro['p_name']) ?>">
                                                </a>

                                                <!-- Wishlist Button -->
                                                <button class="wishlist-btn" data-product="<?= $pro['p_id'] ?>">
                                                    <?php
                                                    $wishIconClass = 'fa-regular';
                                                    if (isset($_SESSION['yid'])) {
                                                        $checkWish = $this->db->query("SELECT * FROM wishlist WHERE user_id=? AND product_id=?", [$_SESSION['yid'], $pro['p_id']])->row();
                                                        if ($checkWish) $wishIconClass = 'fa-solid';
                                                    }
                                                    ?>
                                                    <i class="fa-heart <?= $wishIconClass ?>" style="color:#ff6b6b; font-size:20px;"></i>
                                                </button>
                                            </div>
                                            <div class="shop-content">
                                                <p><?= htmlspecialchars($catName) ?></p>
                                                <h3><a href="<?= $url ?>"><?= htmlspecialchars($pro['p_name']) ?></a></h3>
                                                <ul class="price-list">
                                                    <li>₹<?= number_format($pro['p_price'], 2) ?></li>
                                                    <?php if ($pro['p_mrp'] > $pro['p_price']): ?>
                                                        <li><del>₹<?= number_format($pro['p_mrp'], 2) ?></del></li>
                                                    <?php endif; ?>
                                                </ul>
                                                <ul class="author-post">
                                                    <li class="authot-list">
                                                        <span class="content"><?= htmlspecialchars($pro['p_vendor']) ?></span>
                                                    </li>
                                                </ul>
                                                <div class="rating-line">
                                                    <div class="star">
                                                        <?php for ($i = 1; $i <= 5; $i++): ?>
                                                            <i class="fa-<?= $i <= $pro['p_star'] ? 'solid' : 'regular' ?> fa-star"></i>
                                                        <?php endfor; ?>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="shop-button">
                                                <a href="<?= $url ?>" class="theme-btn">Buy Now</a>
                                            </div>
                                        </div>

                                    </div>
                                <?php 
                                endforeach;
                                endif;
                                ?>
                            </div>
                        </div>

                        <!-- Category-specific Tabs -->
                        <?php foreach ($thecats as $cat):
                            $tabId = 'pills-' . url_smart($cat['name']);
                            // Filter by subcategory if selected, otherwise by category
                            if ($current_subcat_id > 0) {
                                // When subcategory is selected, show products from that subcategory
                                $catProds = $this->db->query("SELECT * FROM yn_ecom_products WHERE p_sub_category=? ORDER BY p_id DESC LIMIT 12", [$current_subcat_id])->result_array();
                            } elseif ($current_cat_id > 0 && $cat['ctid'] == $current_cat_id) {
                                // When specific category is selected and matches this tab, show all products from that category
                                $catProds = $this->db->query("SELECT * FROM yn_ecom_products WHERE p_category=? ORDER BY p_id DESC LIMIT 12", [$cat['ctid']])->result_array();
                            } else {
                                // Default: show products from this category tab
                            $catProds = $this->db->query("SELECT * FROM yn_ecom_products WHERE p_category=? ORDER BY p_id DESC LIMIT 12", [$cat['ctid']])->result_array();
                            }
                        ?>
                            <div class="tab-pane fade" id="<?= $tabId ?>" role="tabpanel" aria-labelledby="<?= $tabId ?>-tab">
                                <div class="row shop-products-row g-2">
                                    <?php 
                                    if (empty($catProds)):
                                        $subcatName = '';
                                        if ($current_subcat_id > 0) {
                                            $subcatInfo = $this->db->query("SELECT sc_name FROM yn_site_sub_cat WHERE sc_id = ?", [$current_subcat_id])->row_array();
                                            $subcatName = !empty($subcatInfo['sc_name']) ? $subcatInfo['sc_name'] : '';
                                        }
                                    ?>
                                        <div class="col-12">
                                            <div class="alert alert-info text-center" role="alert">
                                                <h5>No products found</h5>
                                                <?php if ($current_subcat_id > 0 && !empty($subcatName)): ?>
                                                    <p>No products available in the subcategory "<?= htmlspecialchars($subcatName) ?>".</p>
                                                <?php else: ?>
                                                    <p>No products available in this category.</p>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php 
                                    else:
                                    foreach ($catProds as $pro):
                                        $url = base_url('product/' . $pro['p_id'] . '/' . url_smart($pro['p_name']));
                                    ?>

                                        <div class="col-6 col-md-4 col-lg-3 wow fadeInUp" data-wow-delay=".2s">
                                            <div class="shop-box-items">
                                            <div class="book-thumb center">
                                                <a href="<?= $url ?>">
                                                    <img src="<?= base_url('assets/avator/upload/' . $pro['p_cover']) ?>" alt="<?= htmlspecialchars($pro['p_name']) ?>">
                                                </a>
                                                
                                                <!-- Wishlist Button -->
                                                <button class="wishlist-btn" data-product="<?= $pro['p_id'] ?>">
                                                    <?php
                                                    $wishIconClass = 'fa-regular';
                                                    if (isset($_SESSION['yid'])) {
                                                        $checkWish = $this->db->query("SELECT * FROM wishlist WHERE user_id=? AND product_id=?", [$_SESSION['yid'], $pro['p_id']])->row();
                                                        if ($checkWish) $wishIconClass = 'fa-solid';
                                                    }
                                                    ?>
                                                    <i class="fa-heart <?= $wishIconClass ?>" style="color:#ff6b6b; font-size:20px;"></i>
                                                </button>
                                            </div>
                                                <div class="shop-content">
                                                    <p><?= !empty($cat['name']) ? $cat['name'] : 'General' ?></p>
                                                    <h3><a href="<?= $url ?>"><?= htmlspecialchars($pro['p_name']) ?></a></h3>
                                                    <ul class="price-list">
                                                        <li>₹<?= number_format($pro['p_price'], 2) ?></li>
                                                        <?php if ($pro['p_mrp'] > $pro['p_price']): ?>
                                                            <li><del>₹<?= number_format($pro['p_mrp'], 2) ?></del></li>
                                                        <?php endif; ?>
                                                    </ul>
                                                    <ul class="author-post">
                                                        <li class="authot-list">
                                                            <span class="content"><?= htmlspecialchars($pro['p_vendor']) ?></span>
                                                        </li>
                                                    </ul>
                                                    <div class="rating-line">
                                                        <div class="star">
                                                            <?php for ($i = 1; $i <= 5; $i++): ?>
                                                                <i class="fa-<?= $i <= $pro['p_star'] ? 'solid' : 'regular' ?> fa-star"></i>
                                                            <?php endfor; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="shop-button">
                                                    <a href="<?= $url ?>" class="theme-btn">Buy Now</a>
                                                </div>
                                            </div>
                                        </div>
                                    <?php 
                                    endforeach;
                                    endif;
                                    ?>
                                </div>
                            </div>
                        <?php endforeach; ?>

                    </div>
                </div>
                <!-- End Shop Products -->

            </div>
        </div>
    </div>
</section>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    $(document).ready(function() {
        $('.wishlist-btn').click(function() {
            var product_id = $(this).data('product');
            var btn = $(this);

            <?php if (!isset($_SESSION['yid'])): ?>
                window.location.href = "<?= base_url('login') ?>";
                return;
            <?php endif; ?>

            $.ajax({
                url: "<?= base_url('index.php/action/wishlist_toggle') ?>",
                type: "POST",
                data: {
                    product_id: product_id
                },
                dataType: "json",
                success: function(res) {
                    if (res.status === 'added') {
                        btn.find('i').removeClass('fa-regular').addClass('fa-solid');
                        Swal.fire({
                            icon: 'success',
                            title: 'Added to Wishlist',
                            toast: true,
                            position: 'top-end',
                            timer: 1500,
                            showConfirmButton: false
                        });
                    } else if (res.status === 'removed') {
                        btn.find('i').removeClass('fa-solid').addClass('fa-regular');
                        Swal.fire({
                            icon: 'info',
                            title: 'Removed from Wishlist',
                            toast: true,
                            position: 'top-end',
                            timer: 1500,
                            showConfirmButton: false
                        });
                    }
                    // Update header count
                    $('.header-icon .number').text(res.count);
                },
                error: function() {
                    Swal.fire({
                        icon: 'error',
                        title: 'Something went wrong!',
                        toast: true,
                        position: 'top-end',
                        timer: 1500,
                        showConfirmButton: false
                    });
                }
            });
        });
    });
</script>