<!-- Signup Section Start -->

<style>
    .py-5 {
        padding-top: 6rem !important;
        padding-bottom: 3rem !important;
    }
</style>
<section class="login-section py-5">
    <div class="container">
            <div class="row justify-content-center">
            <div class="col-12 col-md-10 col-lg-5">
                <div class="login-content shadow-box p-4 p-md-5 bg-white rounded-3 text-center">

                    <h2 class="mb-3">Join Us Today!</h2>
                    <p class="mb-4 text-muted">Create your account to explore our bookstore, get personalized recommendations, and enjoy a seamless shopping experience.</p>

                    <form class="login-form" id="signupForm" action="<?= base_url('index.php/action/profile') ?>" method="post"
                            onsubmit="return ajaxsubmitform('<?= base_url('index.php/action/signup') ?>',
                                        this,'error_div','loder_div',
                                        '<?= base_url('index.php/main/otp-verify') ?>',
                                        '0');">

                        <div class="row g-3">

                                <!-- Name -->
                                <div class="col-12 col-lg-6">
                                    <div class="form-clt">
                                        <input type="text" id="name" placeholder="Your Name" name="name">
                                    </div>
                                </div>

                                <!-- Email -->
                                <div class="col-12 col-lg-6">
                                    <div class="form-clt">
                                        <input type="email" id="email123" placeholder="Your Email" name="email">
                                    </div>
                                </div>

                                <!-- Phone -->
                                <div class="col-12 col-lg-6">
                                    <div class="form-clt">
                                        <input type="text" placeholder="Your Phone" name="phone">
                                    </div>
                                </div>

                                <!-- Password -->
                                <div class="col-12 col-lg-6">
                                    <div class="form-clt position-relative">
                                        <input type="password" placeholder="Your Password"
                                        name="pass" id="password-field">
                                        <span class="eye-icon" onclick="togglePassword()">
                                            <i id="toggleIcon" class="fa-solid fa-eye"></i>
                                        </span>
                                    </div>
                                </div>

                            <!-- Referred By (Optional) -->
                            <div class="col-12 col-lg-6">
                                <div class="form-clt">
                                    <input type="text" 
                                        placeholder="Referred By (Referral Code - Optional)" 
                                        name="refer_code" 
                                        id="refer_code"
                                        value="<?= isset($_GET['refer']) ? htmlspecialchars($_GET['refer']) : '' ?>">
                                    <small class="text-muted d-block mt-1" style="font-size: 11px;">
                                        Enter referral code if someone referred you
                                    </small>
                                    <div id="refer_code_message" class="mt-1 text-center" style="font-size: 11px; min-height: 16px;"></div>
                                </div>
                            </div>

                            <!-- Referrer Name (shown when valid code is entered) -->
                            <div class="col-12 col-lg-6" id="referrer_name_field" style="display: none;">
                                <div class="form-clt">
                                    <input type="text" 
                                        id="referrer_name_display" 
                                        placeholder="Referred By Name"
                                        readonly 
                                        style="background-color: #f8f9fa; cursor: not-allowed; width: 100%; padding: 10px 15px; border-radius: 8px; border: 1px solid #ddd; box-shadow: 0 5px 15px rgba(255, 123, 107, 0.15);">
                                </div>
                            </div>

                                <!-- Captcha -->
                                <div class="col-12 text-center">
                                    <?= get_captcha('caprght_oplkion', 'sign9_form_90_feed'); ?>
                                </div>

                                <!-- Privacy Policy -->
                                <div class="col-12 text-center">
                                    <p class="mb-0 fs-xxs">
                                        By signing up, I agree to
                                        <a href="<?= base_url('privacy') ?>" class="text-dark">Privacy Policy</a>
                                    </p>
                                </div>

                                <!-- Submit Button -->
                            <div class="col-12 mt-3">
                                <button type="submit" class="theme-btn style-2 w-100">Signup <i class="fa-solid fa-arrow-right-long"></i></button>
                                </div>

                            <!-- Sign in Link -->
                            <div class="col-12 text-center mt-3">
                                <p class="mb-0 fs-xs">Already have an Account? <a href="<?= base_url('login' . (isset($_GET['redirect']) ? '?redirect=' . urlencode($_GET['redirect']) : '')) ?>">Sign in</a></p>
                            </div>

                            </div>
                        </form>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Error and Loader Divs -->
<div id="error_div"></div>
<div id="loder_div" style="display:none;"></div>

<!-- Password Toggle Script -->
<script>
    function togglePassword() {
        const passwordField = document.getElementById("password-field");
        const toggleIcon = document.getElementById("toggleIcon");

        if (passwordField.type === "password") {
            passwordField.type = "text";
            toggleIcon.classList.replace("fa-eye", "fa-eye-slash");
        } else {
            passwordField.type = "password";
            toggleIcon.classList.replace("fa-eye-slash", "fa-eye");
        }
    }

    // Referral Code Validation
    $(document).ready(function() {
        let referralTimeout;
        const referCodeInput = document.getElementById('refer_code');
        const referrerNameField = document.getElementById('referrer_name_field');
        const referrerNameDisplay = document.getElementById('referrer_name_display');
        const referCodeMessage = document.getElementById('refer_code_message');

        // Ensure referrer name field is hidden on page load
        if (referrerNameField) {
            referrerNameField.style.display = 'none';
            if (referrerNameDisplay) {
                referrerNameDisplay.value = '';
            }
        }

        if (referCodeInput) {
            // Check on page load if there's a value (from URL) - auto-validate immediately
            if (referCodeInput.value && referCodeInput.value.trim().length > 0) {
                // Small delay to ensure DOM and jQuery are fully ready
                setTimeout(function() {
                    validateReferralCode(referCodeInput.value.trim());
                }, 300);
            } else {
                // Clear any existing values if no referral code
                hideReferrerName();
                if (referCodeMessage) {
                    referCodeMessage.innerHTML = '';
                }
            }

            // Validate on input (with debounce)
            referCodeInput.addEventListener('input', function() {
                clearTimeout(referralTimeout);
                const code = this.value.trim();
                
                if (code.length === 0) {
                    hideReferrerName();
                    if (referCodeMessage) {
                        referCodeMessage.innerHTML = '';
                    }
                    return;
                }

                // Wait 500ms after user stops typing
                referralTimeout = setTimeout(function() {
                    validateReferralCode(code);
                }, 500);
            });

            // Validate on blur (when user leaves the field)
            referCodeInput.addEventListener('blur', function() {
                clearTimeout(referralTimeout);
                const code = this.value.trim();
                if (code.length > 0) {
                    validateReferralCode(code);
                } else {
                    hideReferrerName();
                    if (referCodeMessage) {
                        referCodeMessage.innerHTML = '';
                    }
                }
            });
        }

        function validateReferralCode(code) {
            if (!code || code.length === 0) {
                hideReferrerName();
                if (referCodeMessage) {
                    referCodeMessage.innerHTML = '';
                }
                return;
            }

            // Show loading state
            if (referCodeMessage) {
                referCodeMessage.innerHTML = '<span style="color: #666;">Validating...</span>';
                referCodeMessage.style.color = '#666';
            }

            // Make AJAX request
            $.ajax({
                url: '<?= base_url('action/validate_referral_code') ?>',
                type: 'POST',
                data: {
                    refer_code: code
                },
                dataType: 'json',
                success: function(response) {
                    if (response.valid === true && response.name) {
                        // Valid code - show referrer name
                        if (referrerNameDisplay) {
                            referrerNameDisplay.value = response.name;
                        }
                        if (referrerNameField) {
                            referrerNameField.style.display = 'block';
                        }
                        if (referCodeMessage) {
                            referCodeMessage.innerHTML = '<span style="color: #28a745;">✓ Valid referral code</span>';
                            referCodeMessage.style.color = '#28a745';
                        }
                    } else {
                        // Invalid code
                        hideReferrerName();
                        if (referCodeMessage) {
                            referCodeMessage.innerHTML = '<span style="color: #dc3545;">' + (response.message || 'Invalid referral code') + '</span>';
                            referCodeMessage.style.color = '#dc3545';
                        }
                    }
                },
                error: function() {
                    hideReferrerName();
                    if (referCodeMessage) {
                        referCodeMessage.innerHTML = '<span style="color: #dc3545;">Error validating code. Please try again.</span>';
                        referCodeMessage.style.color = '#dc3545';
                    }
                }
            });
        }

        function hideReferrerName() {
            if (referrerNameField) {
                referrerNameField.style.display = 'none';
            }
            if (referrerNameDisplay) {
                referrerNameDisplay.value = '';
            }
        }
    });
</script>

<!-- Custom CSS -->
<style>
    .login-content {
        background: #fff;
        padding: 40px 30px;
        border-radius: 12px;
        box-shadow: 0 10px 30px rgba(84, 173, 222, 0.54);
        text-align: center;
    }

    .login-content h2 {
        font-size: 1.8rem;
        color: linear-gradient(90deg, #251660, #1276BB);
    }

    .login-content p {
        color: #555;
    }

    .form-clt input {
        width: 100%;
        padding: 10px 15px;
        border-radius: 8px;
        border: 1px solid #ddd;
        box-shadow: 0 5px 15px rgba(255, 123, 107, 0.15);
        transition: all 0.3s ease;
        color: #333;
    }

    .form-clt input:focus {
        outline: none;
        border-color: linear-gradient(90deg, #251660, #1276BB);
        box-shadow: 0 5px 15px #018EDC;
    }

    .eye-icon {
        position: absolute;
        top: 50%;
        right: 12px;
        transform: translateY(-50%);
        cursor: pointer;
        color: #555;
    }

    .theme-btn.style-2 {
        background: linear-gradient(90deg, #251660, #1276BB);
        color: #fff;
        border: none;
        padding: 12px 20px;
        border-radius: -4px;
        font-weight: 600;
        transition: all 0.3s ease;
    }

    .theme-btn.style-2:hover {
        background: linear-gradient(90deg, #251660, #1276BB);
    }

    @media (max-width: 767px) {
        .login-content {
            padding: 25px 20px;
        }

        .login-content h2 {
            font-size: 1.5rem;
        }
    }
</style>
