<?php
$get_sliders = $this->db->query("SELECT * FROM yn_site_img WHERE img_place = 'Study' AND img_status='1' ORDER BY img_id DESC");
$allsliedsrs = $get_sliders->result_array();
?>

<style>
    :root {
        --primary-color: #FF7B6B;
        --primary-light: #FF7B6B;
        --secondary-color: #FF7B6B;
        --accent-color: #f72585;
        --light-bg: #f8f9fa;
        --dark-text: #212529;
        --light-text: #6c757d;
        --card-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
        --card-shadow-hover: 0 15px 40px rgba(0, 0, 0, 0.12);
        --transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
    }

    .study-section {
        background: linear-gradient(135deg, rgb(255, 255, 255) 0%, rgb(255, 255, 255) 100%);
        min-height: 100vh;
        padding: 2rem 0;
    }

    .section-header {
        text-align: center;
        margin-bottom: 2rem;
    }

    .section-title {
        font-weight: 700;
        color: var(--primary-color);
        margin-bottom: 0.5rem;
        font-size: 2.5rem;
    }

    .section-subtitle {
        color: var(--light-text);
        font-size: 1.1rem;
        max-width: 600px;
        margin: 0 auto;
    }

    .study-card {
        transition: var(--transition);
        border: none !important;
        border-radius: 16px;
        overflow: hidden;
        background: white;
        height: 100%;
        box-shadow: var(--card-shadow);
        display: flex;
        flex-direction: column;
    }

    .study-card:hover {
        transform: translateY(-8px);
        box-shadow: var(--card-shadow-hover);
    }

    .card-thumbnail {
        height: 480px;
        width: 100%;
        position: relative;
        overflow: hidden;
        flex-shrink: 0;
    }

    .card-thumbnail img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.5s ease;
    }

    .study-card:hover .card-thumbnail img {
        transform: scale(1.05);
    }

    .file-icon {
        font-size: 4rem;
        color: var(--primary-color);
        opacity: 0.8;
    }

    .badge-study {
        background: linear-gradient(45deg, var(--primary-color), var(--primary-light)) !important;
        border: none;
        font-size: 0.75rem;
        padding: 0.35rem 0.75rem;
        border-radius: 50px;
    }

    .card-content {
        padding: 1.5rem;
        display: flex;
        flex-direction: column;
        flex-grow: 1;
    }

    .card-title {
        font-weight: 600;
        color: var(--dark-text);
        margin-bottom: 0.75rem;
        line-height: 1.4;
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }

    .card-description {
        color: var(--light-text);
        font-size: 0.9rem;
        line-height: 1.5;
        flex-grow: 1;
        margin-bottom: 1.25rem;
        display: -webkit-box;
        -webkit-line-clamp: 3;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }

    .btn-study {
        background: linear-gradient(45deg, var(--primary-color), var(--primary-light));
        border: none;
        color: white;
        transition: var(--transition);
        padding: 0.6rem 1.5rem;
        border-radius: 50px;
        font-weight: 500;
        align-self: flex-start;
        box-shadow: 0 4px 10px rgba(67, 97, 238, 0.3);
        margin-top: auto;
    }

    .btn-study:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 15px rgba(67, 97, 238, 0.4);
        color: white;
        background: linear-gradient(45deg, var(--secondary-color), var(--primary-color));
    }

    .modal-header {
        background: linear-gradient(45deg, var(--primary-color), var(--primary-light));
        color: white;
        border-bottom: none;
        padding: 1.5rem;
    }

    .modal-title {
        font-weight: 600;
    }

    .modal-header .btn-close {
        filter: invert(1);
        opacity: 0.8;
    }

    .modal-header .btn-close:hover {
        opacity: 1;
    }

    .modal-body {
        padding: 1.5rem;
    }

    .modal-content {
        border: none;
        border-radius: 16px;
        overflow: hidden;
        box-shadow: 0 20px 60px rgba(0, 0, 0, 0.2);
    }

    .file-preview {
        border-radius: 12px;
        overflow: hidden;
        margin-bottom: 1.5rem;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
    }

    .file-preview img,
    .file-preview video {
        width: 100%;
        display: block;
    }

    .pdf-container {
        height: 500px;
        border: 1px solid #e9ecef;
        border-radius: 12px;
        overflow: hidden;
    }

    .pdf-container iframe {
        width: 100%;
        height: 100%;
        border: none;
    }

    .empty-state {
        text-align: center;
        padding: 4rem 2rem;
        color: var(--light-text);
    }

    .empty-state i {
        font-size: 4rem;
        margin-bottom: 1.5rem;
        color: #dee2e6;
    }

    .empty-state h3 {
        font-weight: 500;
        margin-bottom: 0.5rem;
    }

    .filter-buttons {
        display: flex;
        justify-content: center;
        flex-wrap: wrap;
        gap: 0.75rem;
        margin-bottom: 2rem;
    }

    .filter-btn {
        background: white;
        border: 1px solid #e2e8f0;
        color: var(--light-text);
        padding: 0.5rem 1.25rem;
        border-radius: 50px;
        transition: var(--transition);
        font-size: 0.9rem;
    }

    .filter-btn:hover,
    .filter-btn.active {
        background: var(--primary-color);
        color: white;
        border-color: var(--primary-color);
    }

    .video-overlay {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.2);
        display: flex;
        align-items: center;
        justify-content: center;
        opacity: 0.9;
        transition: opacity 0.3s ease;
    }

    .video-overlay i {
        font-size: 3rem;
        color: white;
    }

    .study-card:hover .video-overlay {
        opacity: 1;
    }

    @media (max-width: 768px) {
        .section-title {
            font-size: 2rem;
        }

        .card-thumbnail {
            height: 200px;
        }

        .filter-buttons {
            gap: 0.5rem;
        }

        .filter-btn {
            padding: 0.4rem 1rem;
            font-size: 0.85rem;
        }

        .study-section {
            padding: 1.5rem 0;
        }
    }
</style>

<div class="study-section" style="margin-bottom: 70px;">
    <div class="container">
        <div class="section-header">
            <h1 class="section-title">Study Resources</h1>
            <p class="section-subtitle">Access learning materials, documents, and multimedia content to support your studies</p>
        </div>

        <!-- Filter Buttons -->
        <div class="filter-buttons">
            <button class="filter-btn active" data-filter="all">All Resources</button>
            <button class="filter-btn" data-filter="image">Images</button>
            <button class="filter-btn" data-filter="pdf">PDFs</button>
            <button class="filter-btn" data-filter="video">Videos</button>
        </div>

        <div class="row g-4" id="study-resources">
            <?php if (!empty($allsliedsrs)): ?>
                <?php foreach ($allsliedsrs as $index => $slider):
                    $file_url = !empty($slider['img_name']) ? base_url('assets/avator/upload/') . $slider['img_name'] : '';
                    $file_ext = $file_url ? strtolower(pathinfo($slider['img_name'], PATHINFO_EXTENSION)) : '';
                    $file_type = 'other';

                    if (in_array($file_ext, ['jpg', 'jpeg', 'png', 'gif'])) {
                        $badge = '<span class="badge badge-study">Image</span>';
                        $thumb = '<div class="card-thumbnail">
                                    <img src="' . $file_url . '" alt="' . htmlspecialchars($slider['img_head'] ?? 'Study Image') . '">
                                  </div>';
                        $icon = '<i class="bi bi-image-fill file-icon"></i>';
                        $file_type = 'image';
                    } elseif ($file_ext === 'pdf') {
                        $badge = '<span class="badge badge-study">PDF</span>';
                        $thumb = '<div class="card-thumbnail d-flex align-items-center justify-content-center bg-light">
                                    <i class="bi bi-file-earmark-pdf-fill file-icon"></i>
                                  </div>';
                        $icon = '<i class="bi bi-file-earmark-pdf-fill file-icon"></i>';
                        $file_type = 'pdf';
                    } elseif ($file_ext === 'mp4') {
                        $badge = '<span class="badge badge-study">Video</span>';
                        $thumb = '<div class="card-thumbnail position-relative">
                                    <video muted class="w-100 h-100" style="object-fit: cover;">
                                        <source src="' . $file_url . '" type="video/mp4">
                                    </video>
                                    <div class="video-overlay">
                                        <i class="bi bi-play-circle-fill"></i>
                                    </div>
                                  </div>';
                        $icon = '<i class="bi bi-play-circle-fill file-icon"></i>';
                        $file_type = 'video';
                    } else {
                        $badge = '<span class="badge badge-study">File</span>';
                        $thumb = '<div class="card-thumbnail d-flex align-items-center justify-content-center bg-light">
                                    <i class="bi bi-file-earmark-fill file-icon"></i>
                                  </div>';
                        $icon = '<i class="bi bi-file-earmark-fill file-icon"></i>';
                        $file_type = 'other';
                    }
                ?>
                    <!-- Card -->
                    <div class="col-md-6 col-lg-4 study-item" data-type="<?= $file_type ?>">
                        <div class="card study-card">
                            <?= $thumb ?>
                            <div class="card-content">
                                <div class="d-flex justify-content-between align-items-start mb-2">
                                    <h5 class="card-title"><?= !empty($slider['img_head']) ? $slider['img_head'] : 'Study Content' ?></h5>
                                    <?= $badge ?>
                                </div>
                                <p class="card-description"><?= trim_text(strip_tags($slider['img_text']), 100) ?></p>
                                <button class="btn btn-study" data-bs-toggle="modal" data-bs-target="#studyModal<?= $index ?>">
                                    View Details
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Modal -->
                    <div class="modal fade" id="studyModal<?= $index ?>" tabindex="-1">
                        <div class="modal-dialog modal-lg modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title"><?= $slider['img_head'] ?></h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                </div>
                                <div class="modal-body">
                                    <div class="file-preview">
                                        <?php if ($file_ext && in_array($file_ext, ['jpg', 'jpeg', 'png', 'gif'])): ?>
                                            <img src="<?= $file_url ?>" class="img-fluid">
                                        <?php elseif ($file_ext === 'pdf'): ?>
                                            <div class="pdf-container">
                                                <iframe src="<?= $file_url ?>#toolbar=0&navpanes=0" width="100%" height="100%"></iframe>
                                            </div>
                                        <?php elseif ($file_ext === 'mp4'): ?>
                                            <video class="w-100" controls>
                                                <source src="<?= $file_url ?>" type="video/mp4">
                                            </video>
                                        <?php else: ?>
                                            <div class="d-flex align-items-center justify-content-center bg-light p-5 rounded">
                                                <?= $icon ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="content-details">
                                        <?php if (!empty($slider['img_text'])): ?>
                                            <p class="mb-3"><?= nl2br(strip_tags($slider['img_text'])) ?></p>
                                        <?php endif; ?>
                                        <?php if (!empty($slider['img_text2'])): ?>
                                            <p class="text-muted"><?= nl2br(strip_tags($slider['img_text2'])) ?></p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="col-12">
                    <div class="empty-state">
                        <i class="bi bi-folder-x"></i>
                        <h3>No study content found</h3>
                        <p>Check back later for new learning materials</p>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<script>
    // Filter functionality
    document.addEventListener('DOMContentLoaded', function() {
        const filterButtons = document.querySelectorAll('.filter-btn');
        const studyItems = document.querySelectorAll('.study-item');

        filterButtons.forEach(button => {
            button.addEventListener('click', function() {
                // Update active button
                filterButtons.forEach(btn => btn.classList.remove('active'));
                this.classList.add('active');

                const filterValue = this.getAttribute('data-filter');

                // Filter items
                studyItems.forEach(item => {
                    if (filterValue === 'all' || item.getAttribute('data-type') === filterValue) {
                        item.style.display = 'block';
                    } else {
                        item.style.display = 'none';
                    }
                });
            });
        });

        // Add play functionality to video thumbnails
        document.querySelectorAll('.card-thumbnail video').forEach(video => {
            const overlay = video.parentElement.querySelector('.video-overlay');

            video.addEventListener('mouseenter', function() {
                this.play();
                if (overlay) overlay.style.opacity = '0';
            });

            video.addEventListener('mouseleave', function() {
                this.pause();
                this.currentTime = 0;
                if (overlay) overlay.style.opacity = '0.9';
            });
        });
    });
</script>