<style>
  .container {
    max-width: 1900px !important;
  }

  /* Responsive Vimeo video */
  .video-wrapper {
    position: relative;
    padding-bottom: 56.25%;
    /* 16:9 aspect ratio */
    padding-top: 30px;
    height: 0;
    overflow: hidden;
    border: 6px solid #098FD9;
    border-radius: 8px;
    margin-bottom: 20px;
  }

  .video-wrapper iframe {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
  }

  /* Buttons styling */
  .e-btn {
    display: inline-block;
    padding: 10px 15px;
    margin-bottom: 10px;
    border-radius: 5px;
    font-size: 0.95rem;
    transition: all 0.3s;
    text-decoration: none;
  }

  .e-btn:hover {
    opacity: 0.85;
  }

  .bg-danger {
    background-color: #dc3545;
    color: #fff;
  }

  .bg-success {
    background-color: #28a745;
    color: #fff;
  }

  .bg-primary {
    background-color: #098FD9;
    color: #fff;
  }

  /* Tabs styling */
  .nav-tabs .nav-link {
    border-radius: 5px 5px 0 0;
    font-weight: 500;
    transition: all 0.3s;
  }

  .nav-tabs .nav-link.active {
    background-color: #098FD9;
    color: #fff !important;
  }

  /* Material list cards */
  .the_materials_right_scroll,
  .the_materials_scroll {
    max-height: 600px;
    overflow-y: auto;
    padding-right: 5px;
  }

  .the_materials_right_scroll .col-12,
  .the_materials_scroll .col-12 {
    border-radius: 6px;
    box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
    transition: all 0.3s;
    background-color: #fff;
    padding: 10px;
    margin-bottom: 10px;
  }

  .the_materials_right_scroll .col-12:hover,
  .the_materials_scroll .col-12:hover {
    transform: scale(1.02);
  }

  @media (max-width: 992px) {
    .video-wrapper {
      padding-bottom: 75%;
    }

    .e-btn {
      font-size: 0.85rem;
      padding: 8px 12px;
      margin-bottom: 8px;
    }

    .the_materials_right_scroll,
    .the_materials_scroll {
      max-height: 400px;
    }
  }

  @media (max-width: 576px) {
    .e-btn {
      font-size: 0.8rem;
      padding: 6px 10px;
    }

    .nav-tabs .nav-link {
      font-size: 0.85rem;
    }
  }

  /* Recorded Videos Styling */
  .recorded-video-card {
    transition: transform 0.3s, box-shadow 0.3s;
  }

  .recorded-video-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 4px 12px rgba(9, 143, 217, 0.2);
  }

  .video-thumbnail-wrapper:hover .video-placeholder {
    opacity: 0.8;
  }
</style>

<script>
  function playVideo(index) {
    const videoElement = document.getElementById('video-' + index);
    const placeholder = videoElement.parentElement.querySelector('.video-placeholder');
    
    if (videoElement.style.display === 'none' || videoElement.style.display === '') {
      // Show and play video
      placeholder.style.display = 'none';
      videoElement.style.display = 'block';
      videoElement.play();
    } else {
      // Hide video
      videoElement.pause();
      videoElement.style.display = 'none';
      placeholder.style.display = 'flex';
    }
  }

  // Pause all other videos when one is played
  document.addEventListener('play', function(e) {
    const videos = document.getElementsByTagName('video');
    for (let i = 0; i < videos.length; i++) {
      if (videos[i] != e.target) {
        videos[i].pause();
        const placeholder = videos[i].parentElement.querySelector('.video-placeholder');
        if (placeholder) {
          videos[i].style.display = 'none';
          placeholder.style.display = 'flex';
        }
      }
    }
  }, true);
</script>

<section id="contact" class="contact-area pt-145 pb-245" style="background-image:url(<?= base_url('assets/theme/img/shape/12.png') ?>)">
  <div class="container pt-sm-4">
    <div class="row">
      <div class="col-12 col-sm-9">
        <?php
        $yid = $_SESSION['yid'];
        $enrol = $_GET['enrol'];
        $smid = $_GET['smid'];

        // Fetch enrollment
        $enrollment = $this->db->query("
          SELECT * 
          FROM x_edu_enrollments e
          JOIN x_edu_courses c ON e.co_course_id = c.course_id
          WHERE e.co_user_id=? AND e.co_id=?
        ", [$yid, $enrol])->row_array();

        if (!empty($enrollment)):
          $course_id = $enrollment['co_course_id'];

          // Fetch the specific material
          $mainMaterial = $this->db->query("
            SELECT * 
            FROM x_edu_study_material 
            WHERE sm_course_id=? AND sm_id=?
          ", [$course_id, $smid])->row_array();

          if ($mainMaterial):
            $vimeoID = preg_replace('/[^0-9]/', '', $mainMaterial['sm_link']);
            
            // Fetch recorded videos for this study material
            $get_videos = $this->db->query("
              SELECT smv.*, lc.lc_title as live_class_title
              FROM yn_study_material_videos smv
              LEFT JOIN yn_live_classes lc ON smv.lc_id = lc.lc_id
              WHERE smv.sm_id = ? 
              AND smv.smv_status = '1'
              ORDER BY smv.smv_created_at ASC
            ", [$smid]);
            $recorded_videos = $get_videos->result_array();
            
            // Debug: Uncomment below line to check if videos are being fetched
            // echo "<!-- Debug: Found " . count($recorded_videos) . " videos for sm_id: $smid -->";
        ?>
            <h4><?= $mainMaterial['sm_name'] ?></h4>

            <?php if ($vimeoID != ''): ?>
              <div class="video-wrapper">
                <iframe src="https://player.vimeo.com/video/<?= $vimeoID ?>?badge=0&autopause=0&autoplay=0&loop=1&muted=1" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen title="<?= $mainMaterial['sm_name'] ?>"></iframe>
              </div>
            <?php endif; ?>

            <?php 
            // Debug: Show video count (remove this after testing)
            // echo "<!-- Debug: Videos found: " . count($recorded_videos) . " for sm_id: $smid -->";
            ?>
            
            <?php if (!empty($recorded_videos)): ?>
              <div class="col-12 mt-4 mb-3">
                <h5 class="mb-3" style="color: #098FD9;">
                  <i class="fas fa-video"></i> Recorded Videos (<?= count($recorded_videos) ?>)
                </h5>
                <div class="row g-3">
                  <?php foreach ($recorded_videos as $index => $video): 
                    // Ensure video URL is correct
                    $video_path = !empty($video['smv_video_url']) ? $video['smv_video_url'] : '';
                    if (!empty($video_path) && strpos($video_path, 'http') !== 0) {
                      $video_url = base_url($video_path);
                    } else {
                      $video_url = $video_path;
                    }
                  ?>
                    <div class="col-md-6 col-lg-4">
                      <div class="card recorded-video-card" style="border: 1px solid #e0e0e0; border-radius: 8px; overflow: hidden; transition: all 0.3s;">
                        <div class="video-thumbnail-wrapper" style="position: relative; padding-bottom: 56.25%; background: #000; cursor: pointer;" onclick="playVideo(<?= $index ?>)">
                          <video id="video-<?= $index ?>" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; display: none;" controls>
                            <source src="<?= $video_url ?>" type="video/mp4">
                            Your browser does not support the video tag.
                          </video>
                          <div class="video-placeholder" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; display: flex; align-items: center; justify-content: center; background: linear-gradient(135deg, #098FD9, #0B8CD4);">
                            <i class="fas fa-play-circle" style="font-size: 48px; color: white; opacity: 0.9;"></i>
                          </div>
                          <?php if (!empty($video['live_class_title'])): ?>
                            <span class="badge" style="position: absolute; top: 10px; right: 10px; background: rgba(9, 143, 217, 0.9); color: white; padding: 5px 10px; border-radius: 4px; font-size: 11px;">
                              <i class="fas fa-chalkboard-teacher"></i> Live Class
                            </span>
                          <?php endif; ?>
                        </div>
                        <div class="card-body p-3">
                          <h6 class="card-title mb-2" style="font-size: 14px; font-weight: 600; color: #333; min-height: 40px;">
                            <?= htmlspecialchars($video['smv_title']) ?>
                          </h6>
                          <?php if (!empty($video['smv_description'])): ?>
                            <p class="card-text" style="font-size: 12px; color: #666; margin-bottom: 0; display: -webkit-box; -webkit-line-clamp: 2; -webkit-box-orient: vertical; overflow: hidden;">
                              <?= htmlspecialchars(strip_tags($video['smv_description'])) ?>
                            </p>
                          <?php endif; ?>
                        </div>
                      </div>
                    </div>
                  <?php endforeach; ?>
                </div>
              </div>
            <?php endif; ?>

            <div class="col-12 p-3">
              <?php if ($mainMaterial['sm_qbank_id'] > 0): ?>
                <a class="e-btn bg-danger" href="<?= base_url('qbank/' . $mainMaterial['sm_qbank_id'] . '/solve_test') ?>" target="_blank"><i class="fa fa-pen"></i> Solve Test</a>
              <?php endif; ?>
              <a class="e-btn bg-success" href="<?= base_url('action/add_bookmark?smid=' . $smid . '&enrol=' . $enrol) ?>"><i class="fa fa-bookmark"></i> Add Bookmark</a>
              <a class="e-btn text-white" style="float:right;background-color:#098FD9;" href="#doubts" data-toggle="collapse"><i class="fas fa-pen"></i> Ask Doubts</a>
            </div>

            <?php if ($mainMaterial['sm_desc'] != ''): ?>
              <div class="col-12 p-3"><?= $mainMaterial['sm_desc'] ?></div>
            <?php endif; ?>

            <?php if ($mainMaterial['sm_file'] != ''): ?>
              <div id="pdfPoints" class="collapse p-3">
                <hr />
                <iframe src="<?= base_url('assets/avator/upload/smaterial/' . $mainMaterial['sm_file']) ?>" style="width:100%;height:700px;"></iframe>
              </div>
            <?php endif; ?>

            <?php if ($enrollment['course_revision'] != ''): ?>
              <div id="revPoints" class="collapse p-3">
                <hr />
                <iframe src="<?= base_url('assets/avator/upload/courses/revision/' . $enrollment['course_revision']) ?>" style="width:100%;height:700px;margin-top:-100px;"></iframe>
              </div>
            <?php endif; ?>

            <div id="doubts" class="collapse p-3">
              <?php
              $type = 'rmaterial';
              $ajax = 'doubt';
              $review_heading = 'Your Doubts';
              include('material_review.php');
              include('inc/ask_your_doubt.php');
              ?>
            </div>
        <?php
          endif;
        else:
          echo "<div class='alert alert-info'>Your Enrollment might have been Expired / Empty data!</div>";
        endif;
        ?>

      </div>

      <?php
      // Fetch other materials
      if (!empty($course_id)):
        $otherMaterials = $this->db->query("
          SELECT * 
          FROM x_edu_study_material LEFT JOIN x_edu_material_bookmark ON sm_id=emb_mat_id 
          WHERE sm_course_id=? AND sm_id!=? AND sm_status='1'
        ", [$course_id, $smid])->result_array();

        if (!empty($otherMaterials)):
      ?>
          <div class="col-12 col-sm-3 mb-3">
            <div class="price__tab-btn text-center mb-20">
              <nav>
                <div class="nav nav-tabs justify-content-center" id="nav-tab" role="tablist">
                  <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#nav-materials">All Materials</button>
                  <button class="nav-link" data-bs-toggle="tab" data-bs-target="#nav-bookmarks">My BookMarks</button>
                </div>
              </nav>
            </div>

            <div class="tab-content">
              <div class="tab-pane fade show active" id="nav-materials">
                <div class="the_materials_right_scroll p-1">
                  <?php foreach ($otherMaterials as $material): ?>
                    <a href="<?= base_url('viewMaterial?enrol=' . $enrol . '&smid=' . $material['sm_id']) ?>">
                      <div class="col-12 mb-2 p-2 bg-white">
                        <h6><?= $material['sm_name'] ?></h6>
                        <p><?php if (!empty($material['emb_mat_id'])) echo '<i class="fas fa-bookmark text-warning"></i> '; ?><?= trim_text(strip_tags($material['sm_desc']), 40) ?></p>
                      </div>
                    </a>
                  <?php endforeach; ?>
                </div>
              </div>
              <div class="tab-pane fade" id="nav-bookmarks">
                <div class="the_materials_scroll p-2">
                  <?php foreach ($otherMaterials as $material):
                    if (!empty($material['emb_mat_id'])): ?>
                      <a href="<?= base_url('viewMaterial?enrol=' . $enrol . '&smid=' . $material['sm_id']) ?>">
                        <div class="col-12 mb-2 p-2 bg-white">
                          <h6><?= $material['sm_name'] ?></h6>
                          <p><?= trim_text(strip_tags($material['sm_desc']), 40) ?></p>
                        </div>
                      </a>
                  <?php endif;
                  endforeach; ?>
                </div>
              </div>
            </div>
          </div>
      <?php
        endif;
      endif;
      ?>
    </div>
</section>