<style>
	/* CSS */
	.icon {
		color: #6C757D;
		/* Your desired color */
		width: 24px;
		/* Optional: adjust size */
		height: 24px;
		/* Optional: adjust size */
	}

	/* Optional: hover effect */
	.icon:hover {
		color: #6C757D;
		/* same or another color on hover */
	}


	/* Example: change color on hover */
	.icon:hover {
		color: #FF7B6B;
		/* green on hover */
	}

	/* Custom CSS for enhanced UI */
	:root {
		--primary-color: #0B8CD4;
		--primary-dark: #0B8CD4;
		--secondary-color: #0B8CD4;
		--light-bg: #f8f9fa;
		--border-color: #e9ecef;
		--text-dark: #212B36;
		--text-light: #6c757d;
	}

	.breadcrumb-section {
		position: relative;
		background: linear-gradient(rgba(0, 0, 0, 0.6), rgba(0, 0, 0, 0.6)), url('https://honey-dale.com/cdn/shop/files/Honey_for_your_diet.png?v=1683704632&width=1500');
		background-size: cover;
		background-position: center;
		height: 280px;
		display: flex;
		align-items: center;
	}

	.breadcrumb-section .pt-120 {
		padding-top: 0 !important;
	}

	.breadcrumb-section h1 {
		font-size: 2.5rem;
		font-weight: 600;
		text-shadow: 0 2px 4px rgba(0, 0, 0, 0.3);
	}

	.my-account {
		background-color: var(--light-bg);
	}

	.account-info {
		box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
		border: 1px solid var(--border-color);
		transition: all 0.3s ease;
	}

	.account-info:hover {
		box-shadow: 0 6px 16px rgba(0, 0, 0, 0.08);
	}

	.profile-inf-right h4 {
		color: var(--text-dark);
		font-weight: 600;
	}

	.info-meta span {
		color: var(--text-light);
		font-size: 0.9rem;
	}

	.info-meta i {
		color: var(--primary-color);
	}

	.achievement-box {
		background: linear-gradient(135deg, #f8f9fa, #e9ecef);
		padding: 12px 16px;
		border-radius: 10px;
		border-left: 4px solid var(--primary-color);
	}

	.achievement-box .icon {
		width: 50px;
		height: 50px;
		background-color: #0B8CD4;
	}

	.achievement-box h4 {
		color: var(--primary-color);
		font-weight: 700;
		margin-bottom: 0.25rem !important;
	}

	.achievement-box span {
		color: var(--text-light);
		font-size: 0.85rem;
	}

	.account-nav {
		box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
		border: 1px solid var(--border-color);
		height: fit-content;
		position: sticky;
		top: 20px;
	}

	.account-nav h6 {
		color: var(--text-dark);
		font-weight: 600;
		font-size: 1.1rem;
	}

	.account-nav-menu li {
		margin-bottom: 8px;
	}

	.account-nav-menu a {
		display: flex;
		align-items: center;
		padding: 12px 16px;
		color: var(--text-dark);
		text-decoration: none;
		border-radius: 8px;
		transition: all 0.3s ease;
		font-weight: 500;
	}

	.account-nav-menu a:hover,
	.account-nav-menu a.active {
		background-color: rgba(33, 177, 105, 0.1);
		color: var(--primary-color);
	}

	.account-nav-menu a svg {
		transition: transform 0.3s ease;
	}

	.account-nav-menu a:hover svg,
	.account-nav-menu a.active svg {
		transform: scale(1.1);
	}

	.order-tracking-wrap {
		box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
		border: 1px solid var(--border-color);
	}

	.order-tracking-wrap h6 {
		color: var(--text-dark);
		font-weight: 600;
		font-size: 1.25rem;
		padding-bottom: 10px;
		border-bottom: 2px solid var(--primary-color);
		display: inline-block;
	}

	.table-responsive-md table {
		border-collapse: separate;
		border-spacing: 0;
		width: 100%;
	}

	.table-responsive-md td {
		padding: 14px 12px;
		border: 1px solid var(--border-color);
	}

	.table-responsive-md td:first-child {
		font-weight: 600;
		background-color: rgba(248, 249, 250, 0.7);
		width: 25%;
	}

	.table-responsive-md td:nth-child(2) {
		width: 25%;
	}

	.table-responsive-md td:nth-child(3) {
		font-weight: 600;
		background-color: rgba(248, 249, 250, 0.7);
		width: 25%;
	}

	.table-responsive-md td:nth-child(4) {
		width: 25%;
	}

	.table-responsive-md .font-weight-bold {
		color: var(--text-dark);
		font-weight: 600 !important;
	}

	fieldset {
		border: 1px solid var(--border-color);
		border-radius: 8px;
		padding: 16px;
		margin: 24px 0;
		background-color: rgba(248, 249, 250, 0.5);
	}

	fieldset h5 {
		color: var(--text-dark);
		font-weight: 600;
		margin-bottom: 0;
		padding: 0 12px;
		background: white;
		display: inline-block;
		position: relative;
		top: -32px;
		margin-bottom: -16px;
	}

	.table-responsive table {
		width: 100%;
	}

	.table-responsive thead th {
		background-color: var(--primary-color);
		color: white;
		font-weight: 600;
		padding: 14px 12px;
		border: none;
	}

	.table-responsive tbody td {
		padding: 12px;
		border-bottom: 1px solid var(--border-color);
	}

	.table-responsive tbody tr:hover {
		background-color: rgba(33, 177, 105, 0.05);
	}

	.alert-info {
		background-color: rgba(33, 177, 105, 0.1);
		border-color: var(--primary-color);
		color: var(--text-dark);
	}

	/* Responsive adjustments */
	@media (max-width: 768px) {
		.breadcrumb-section {
			height: 200px;
		}

		.breadcrumb-section h1 {
			font-size: 2rem;
		}

		.account-info {
			text-align: center;
		}

		.info-meta {
			justify-content: center;
		}

		.table-responsive-md td:first-child,
		.table-responsive-md td:nth-child(3) {
			width: 40%;
		}

		.table-responsive-md td:nth-child(2),
		.table-responsive-md td:nth-child(4) {
			width: 60%;
		}
	}

	/* Animation for page load */
	@keyframes fadeIn {
		from {
			opacity: 0;
			transform: translateY(20px);
		}

		to {
			opacity: 1;
			transform: translateY(0);
		}
	}

	.order-tracking-wrap {
		animation: fadeIn 0.5s ease-out;
	}

	/* Print styles */
	@media print {

		.account-nav,
		.breadcrumb-section {
			display: none;
		}

		.order-tracking-wrap {
			box-shadow: none;
			border: 1px solid #000;
		}
	}
</style>

<div class="breadcrumb-wrapper bg-cover section-padding"
	style="background: linear-gradient(#E8F6FE), 
                     url('<?= base_url('assets/theme/theme/') ?>assets/img/hero/banner.jpg'); 
            background-size: cover;
            background-position: center;">
	<div class="container">
		<div class="page-heading">
			<h1>View Checkout</h1>

		</div>
	</div>
</div>

<!--my account section-->
<section class="my-account pt-6 " style="margin-bottom: 66px;">
	<div class="container">
		<div class="account-info d-flex align-items-center gap-6 p-4 p-sm-6 bg-white rounded mb-4 flex-wrap flex-lg-nowrap">
			<div class="profile-inf-right">
				<h4 class="mb-2"><?= ucfirst($profile_data['name']) ?></h4>
				<div class="info-meta d-flex align-items-center gap-2 gap-md-4 fs-xs flex-wrap">
					<span>
						<i class="fa-solid fa-location-pin me-2"></i>
						<?= $profile_data['address'] ?>
					</span>
					<span>
						<i class="fa-solid fa-phone me-2"></i>
						<?= $profile_data['contact'] ?>
					</span>
					<span>
						<i class="fa-solid fa-envelope me-2"></i>
						<?= $profile_data['email'] ?>
					</span>
				</div>
				<div class="profile-achievements d-flex align-items-center flex-wrap mt-4">
					<div class="achievement-box d-flex align-items-center gap-3">
						<span class="icon d-inline-flex align-items-center justify-content-center flex-shrink-0 bg-color-1 rounded-3">
							<!-- HTML -->
							<svg class="icon" width="26" height="32" viewBox="0 0 26 32" xmlns="http://www.w3.org/2000/svg">
								<path d="M25.3573 26.3886L23.9282 8.38138C23.8392 7.22125 22.8581 6.31244 21.6946 6.31244H18.8719V6.18556C18.8719 2.77481 16.0971 0 12.6863 0C9.27556 0 6.50074 2.77481 6.50074 6.18556V6.31244H3.67812C2.51456 6.31244 1.53337 7.22119 1.44462 8.37894L0.0151202 26.3911C-0.0955048 27.8333 0.404808 29.2691 1.38768 30.3302C2.37056 31.3913 3.76387 32 5.21031 32H20.1622C21.6086 32 23.002 31.3914 23.9849 30.3302C24.9678 29.269 25.4681 27.8333 25.3573 26.3886ZM8.37512 6.18556C8.37512 3.80838 10.3092 1.87437 12.6863 1.87437C15.0634 1.87437 16.9975 3.80844 16.9975 6.18556V6.31244H8.37512V6.18556ZM22.6097 29.0566C21.9711 29.7459 21.102 30.1256 20.1622 30.1256H5.21037C4.27062 30.1256 3.40149 29.7459 2.76287 29.0566C2.12431 28.3671 1.81218 27.4714 1.88393 26.5369L3.31331 8.52469C3.32781 8.33519 3.48806 8.18681 3.67812 8.18681H6.50074V10.4952C6.50074 11.0128 6.92037 11.4324 7.43793 11.4324C7.95549 11.4324 8.37512 11.0128 8.37512 10.4952V8.18681H16.9975V10.4952C16.9975 11.0128 17.4171 11.4324 17.9347 11.4324C18.4522 11.4324 18.8719 11.0128 18.8719 10.4952V8.18681H21.6946C21.8846 8.18681 22.0448 8.33525 22.0596 8.52719L23.4886 26.5344C23.5605 27.4714 23.2483 28.3671 22.6097 29.0566Z" fill="currentColor" />
								<path d="M16.9143 15.8929C16.5484 15.5269 15.955 15.5269 15.5891 15.8929L11.4043 20.0777L9.79519 18.4685C9.42925 18.1025 8.83581 18.1025 8.46981 18.4685C8.10381 18.8345 8.10381 19.4279 8.46981 19.7939L10.7416 22.0657C10.9246 22.2487 11.1645 22.3403 11.4043 22.3403C11.644 22.3403 11.8839 22.2488 12.0669 22.0657L16.9142 17.2183C17.2803 16.8523 17.2803 16.2589 16.9143 15.8929Z" fill="currentColor" />
							</svg>

						</span>
						<div>
							<h4 class="mb-1"><?= count($allorders) ?></h4>
							<span>Total Orders</span>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="row g-4">
			<div class="col-xl-3">
				<div class="account-nav bg-white rounded py-5">
					<h6 class="mb-4 px-4">Manage My Account</h6>
					<ul class="nav nav-tabs border-0 d-block account-nav-menu">
						<li>
							<a href="#dashboard" data-bs-toggle="tab" class="active">
								<span class="me-2">
									<!-- HTML -->
									<svg class="icon" width="13" height="12" viewBox="0 0 13 12" xmlns="http://www.w3.org/2000/svg">
										<path fill-rule="evenodd" clip-rule="evenodd" d="M0.332031 1.33333V0.666667C0.332031 0.3 0.632031 0 0.998698 0H12.332C12.6987 0 12.9987 0.3 12.9987 0.666667V1.33333C12.9987 1.7 12.6987 2 12.332 2H0.998698C0.632031 2 0.332031 1.7 0.332031 1.33333ZM12.332 3.33333H0.998698C0.632031 3.33333 0.332031 3.63333 0.332031 4V8C0.332031 8.36667 0.632031 8.66667 0.998698 8.66667H12.332C12.6987 8.66667 12.9987 8.36667 12.9987 8V4C12.9987 3.63333 12.6987 3.33333 12.332 3.33333ZM0.998698 12H12.332C12.6987 12 12.9987 11.7 12.9987 11.3333V10.6667C12.9987 10.3 12.6987 10 12.332 10H0.998698C0.632031 10 0.332031 10.3 0.332031 10.6667V11.3333C0.332031 11.7 0.632031 12 0.998698 12Z" fill="currentColor" />
									</svg>

								</span>
								Dashboard
							</a>
						</li>

						<!-- <li>
							<a href="#update-profile" data-bs-toggle="tab">
								<span class="me-2">
									<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
										<path d="M3.33333 1.99341H6C6.35362 1.99341 6.69276 2.13388 6.94281 2.38393C7.19286 2.63398 7.33333 2.97312 7.33333 3.32674V5.99341C7.33333 6.34703 7.19286 6.68617 6.94281 6.93622C6.69276 7.18627 6.35362 7.32674 6 7.32674H3.33333C2.97971 7.32674 2.64057 7.18627 2.39052 6.93622C2.14048 6.68617 2 6.34703 2 5.99341V3.32674C2 2.97312 2.14048 2.63398 2.39052 2.38393C2.64057 2.13388 2.97971 1.99341 3.33333 1.99341Z" fill="#212B36" />
										<path d="M10 1.99341H12.6667C13.0203 1.99341 13.3594 2.13388 13.6095 2.38393C13.8595 2.63398 14 2.97312 14 3.32674V5.99341C14 6.34703 13.8595 6.68617 13.6095 6.93622C13.3594 7.18627 13.0203 7.32674 12.6667 7.32674H10C9.64638 7.32674 9.30724 7.18627 9.05719 6.93622C8.80714 6.68617 8.66667 6.34703 8.66667 5.99341V3.32674C8.66667 2.97312 8.80714 2.63398 9.05719 2.38393C9.30724 2.13388 9.64638 1.99341 10 1.99341Z" fill="#212B36" />
										<path d="M6 8.66008H3.33333C2.97971 8.66008 2.64057 8.80055 2.39052 9.0506C2.14048 9.30065 2 9.63979 2 9.99341V12.6601C2 13.0137 2.14048 13.3528 2.39052 13.6029C2.64057 13.8529 2.97971 13.9934 3.33333 13.9934H6C6.35362 13.9934 6.69276 13.8529 6.94281 13.6029C7.19286 13.3528 7.33333 13.0137 7.33333 12.6601V9.99341C7.33333 9.63979 7.19286 9.30065 6.94281 9.0506C6.69276 8.80055 6.35362 8.66008 6 8.66008Z" fill="#212B36" />
										<path d="M10 8.66008H12.6667C13.0203 8.66008 13.3594 8.80055 13.6095 9.0506C13.8595 9.30065 14 9.63979 14 9.99341V12.6601C14 13.0137 13.8595 13.3528 13.6095 13.6029C13.3594 13.8529 13.0203 13.9934 12.6667 13.9934H10C9.64638 13.9934 9.30724 13.8529 9.05719 13.6029C8.80714 13.3528 8.66667 13.0137 8.66667 12.6601V9.99341C8.66667 9.63979 8.80714 9.30065 9.05719 9.0506C9.30724 8.80055 9.64638 8.66008 10 8.66008Z" fill="#212B36" />
									</svg>
								</span>
								Update Profile
							</a>
						</li> -->

						<li>
							<a href="<?= base_url('logout') ?>">
								<span class="me-2">
									<!-- HTML -->
									<svg class="icon" width="16" height="16" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg">
										<path d="M3.33333 1.99341H6C6.35362 1.99341 6.69276 2.13388 6.94281 2.38393C7.19286 2.63398 7.33333 2.97312 7.33333 3.32674V5.99341C7.33333 6.34703 7.19286 6.68617 6.94281 6.93622C6.69276 7.18627 6.35362 7.32674 6 7.32674H3.33333C2.97971 7.32674 2.64057 7.18627 2.39052 6.93622C2.14048 6.68617 2 6.34703 2 5.99341V3.32674C2 2.97312 2.14048 2.63398 2.39052 2.38393C2.64057 2.13388 2.97971 1.99341 3.33333 1.99341Z" fill="currentColor" />
										<path d="M10 1.99341H12.6667C13.0203 1.99341 13.3594 2.13388 13.6095 2.38393C13.8595 2.63398 14 2.97312 14 3.32674V5.99341C14 6.34703 13.8595 6.68617 13.6095 6.93622C13.3594 7.18627 13.0203 7.32674 12.6667 7.32674H10C9.64638 7.32674 9.30724 7.18627 9.05719 6.93622C8.80714 6.68617 8.66667 6.34703 8.66667 5.99341V3.32674C8.66667 2.97312 8.80714 2.63398 9.05719 2.38393C9.30724 2.13388 9.64638 1.99341 10 1.99341Z" fill="currentColor" />
										<path d="M6 8.66008H3.33333C2.97971 8.66008 2.64057 8.80055 2.39052 9.0506C2.14048 9.30065 2 9.63979 2 9.99341V12.6601C2 13.0137 2.14048 13.3528 2.39052 13.6029C2.64057 13.8529 2.97971 13.9934 3.33333 13.9934H6C6.35362 13.9934 6.69276 13.8529 6.94281 13.6029C7.19286 13.3528 7.33333 13.0137 7.33333 12.6601V9.99341C7.33333 9.63979 7.19286 9.30065 6.94281 9.0506C6.69276 8.80055 6.35362 8.66008 6 8.66008Z" fill="currentColor" />
										<path d="M10 8.66008H12.6667C13.0203 8.66008 13.3594 8.80055 13.6095 9.0506C13.8595 9.30065 14 9.63979 14 9.99341V12.6601C14 13.0137 13.8595 13.3528 13.6095 13.6029C13.3594 13.8529 13.0203 13.9934 12.6667 13.9934H10C9.64638 13.9934 9.30724 13.8529 9.05719 13.6029C8.80714 13.3528 8.66667 13.0137 8.66667 12.6601V9.99341C8.66667 9.63979 8.80714 9.30065 9.05719 9.0506C9.30724 8.80055 9.64638 8.66008 10 8.66008Z" fill="currentColor" />
									</svg>

								</span>
								Log out
							</a>
						</li>
					</ul>
				</div>
			</div>
			<div class="col-xl-9">
				<div class="tab-content">
					<?php
					$id = $_GET['ord'];
					$getslider_details = $this->db->query("select * from `yn_ecom_order` where so_order_id='$id' ");
					$theimage_details3 = $getslider_details->row_array();

					if ($getslider_details->num_rows() > 0) {
						$Odr_Details = $getslider_details->result_array();
					?>
						<div class="tab-pane fade show active" id="order-detail">
							<div class="order-tracking-wrap bg-white rounded py-5 px-4">
								<h6 class="mb-4">Order Details</h6>

								<div class="table-responsive-md mt-5">
									<table class="table table-bordered fs-xs">
										<tbody>
											<tr>
												<td>Order #</td>
												<td class="font-weight-bold"><?= $theimage_details3['so_order_id'] ?></td>
												<td>Checkout Date</td>
												<td class="font-weight-bold"><?= $theimage_details3['so_date'] ?></td>
											</tr>
											<tr>
												<td>Name</td>
												<td class="font-weight-bold"><?= $theimage_details3['so_name'] ?></td>
												<td>Billing Address</td>
												<td class="font-weight-bold"><?= $theimage_details3['address'] ?></td>
											</tr>
											<tr>
												<td>Phone#</td>
												<td class="font-weight-bold"><?= $theimage_details3['so_phone'] ?></td>
												<td>Email</td>
												<td class="font-weight-bold"><?= $theimage_details3['so_email'] ?></td>
											</tr>
											<tr>
												<td>Total Price</td>
												<td class="font-weight-bold"><?= money_show($theimage_details3['so_price'], 2) ?></td>
											</tr>
										</tbody>
									</table>
								</div>

								<div class="table-responsive">
									<fieldset>
										<h5>Products List</h5>
									</fieldset>
									<table class="table table-borderless">
										<thead>
											<tr>
												<th>#</th>
												<th>Name</th>
												<th>Price</th>
											</tr>
										</thead>
										<tbody>
											<?php
											$Order_listPro = $this->db->query("SELECT * from `yn_ecom_orders_detail` where checkout_order_id='$id' ");
											if ($Order_listPro->num_rows() > 0) {
												$index = 0;
												foreach ($Order_listPro->result_array() as $productList) {
													$index++;
											?>
													<tr>
														<td><?= $index ?></td>
														<td><?= $productList['xod_title'] ?></td>
														<td><?= money_show($productList['xod_price']) ?></td>
													</tr>
											<?php
												}
											} else {
												echo "<div class='alert alert-info text-center py-3'>No products found in this order.</div>";
											}
											?>
										</tbody>
									</table>
								</div>
							</div>
						</div>
					<?php } ?>
				</div>
			</div>
		</div>
	</div>
</section>
<!--my account section end-->