<?php
// Direct database check - run this to see exact issue
error_reporting(E_ALL);
ini_set('display_errors', 1);

$host = 'localhost';
$dbname = 'ebook';
$username = 'root';
$password = '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "<h2>🔍 COMPLETE VIDEO DEBUGGING</h2>";
    echo "<hr>";
    
    // Step 1: Check video in database
    echo "<h3>Step 1: Video in Database</h3>";
    $q1 = "SELECT * FROM yn_study_material_videos WHERE smv_status = '1'";
    $r1 = $pdo->query($q1);
    $videos = $r1->fetchAll(PDO::FETCH_ASSOC);
    echo "<pre>";
    print_r($videos);
    echo "</pre>";
    echo "<p><strong>Total Videos:</strong> " . count($videos) . "</p>";
    
    if (empty($videos)) {
        echo "<p style='color:red;'><strong>❌ NO VIDEOS FOUND IN DATABASE!</strong></p>";
        die;
    }
    
    $video = $videos[0];
    $sm_id = $video['sm_id'];
    $lc_id = $video['lc_id'];
    
    echo "<p><strong>Video sm_id:</strong> $sm_id</p>";
    echo "<p><strong>Video lc_id:</strong> " . ($lc_id ?? 'NULL') . "</p>";
    echo "<hr>";
    
    // Step 2: Check study material
    echo "<h3>Step 2: Study Material Status</h3>";
    $q2 = "SELECT sm_id, sm_name, sm_status FROM x_edu_study_material WHERE sm_id = $sm_id";
    $r2 = $pdo->query($q2);
    $sm = $r2->fetch(PDO::FETCH_ASSOC);
    echo "<pre>";
    print_r($sm);
    echo "</pre>";
    
    if (empty($sm)) {
        echo "<p style='color:red;'><strong>❌ STUDY MATERIAL NOT FOUND!</strong></p>";
        die;
    }
    
    if ($sm['sm_status'] != '1') {
        echo "<p style='color:red;'><strong>❌ STUDY MATERIAL IS INACTIVE!</strong></p>";
    }
    echo "<hr>";
    
    // Step 3: Check live class (if lc_id exists)
    if (!empty($lc_id)) {
        echo "<h3>Step 3: Live Class Status</h3>";
        $q3 = "SELECT lc_id, lc_title, lc_status, sm_id FROM yn_live_classes WHERE lc_id = $lc_id";
        $r3 = $pdo->query($q3);
        $lc = $r3->fetch(PDO::FETCH_ASSOC);
        echo "<pre>";
        print_r($lc);
        echo "</pre>";
        
        if (empty($lc)) {
            echo "<p style='color:orange;'><strong>⚠️ LIVE CLASS NOT FOUND (but video will still show)</strong></p>";
        }
        echo "<hr>";
    }
    
    // Step 4: Check ALL orders to find user IDs
    echo "<h3>Step 4: All Orders (to find user who purchased)</h3>";
    $q4 = "SELECT DISTINCT so_mid, so_order_id, so_status, or_pay_status 
           FROM yn_ecom_order 
           WHERE so_status = '1' AND or_pay_status = '1'
           ORDER BY so_id DESC LIMIT 10";
    $r4 = $pdo->query($q4);
    $orders = $r4->fetchAll(PDO::FETCH_ASSOC);
    echo "<pre>";
    print_r($orders);
    echo "</pre>";
    
    if (empty($orders)) {
        echo "<p style='color:red;'><strong>❌ NO PAID ORDERS FOUND!</strong></p>";
        die;
    }
    
    // Step 5: Check order details for sm_id
    echo "<h3>Step 5: Order Details for sm_id=$sm_id</h3>";
    $order_ids = array();
    foreach ($orders as $ord) {
        $order_ids[] = $pdo->quote($ord['so_order_id']);
    }
    $order_ids_str = implode(',', $order_ids);
    
    $q5 = "SELECT od.*, o.so_mid, o.so_order_id
           FROM yn_ecom_orders_detail od
           INNER JOIN yn_ecom_order o ON od.checkout_order_id = o.so_order_id
           WHERE od.checkout_order_id IN ($order_ids_str)
           AND (od.xod_pid = $sm_id OR od.xod_sm_id = $sm_id)
           LIMIT 10";
    $r5 = $pdo->query($q5);
    $order_details = $r5->fetchAll(PDO::FETCH_ASSOC);
    echo "<pre>";
    print_r($order_details);
    echo "</pre>";
    
    if (empty($order_details)) {
        echo "<p style='color:red;'><strong>❌ NO USER HAS PURCHASED sm_id=$sm_id!</strong></p>";
        echo "<p>This is why video is not showing. User needs to purchase this study material first.</p>";
    } else {
        $user_id = $order_details[0]['so_mid'];
        echo "<p style='color:green;'><strong>✅ USER ID $user_id HAS PURCHASED sm_id=$sm_id</strong></p>";
        echo "<hr>";
        
        // Step 6: Simulate exact query from code
        echo "<h3>Step 6: Simulate Exact Code Query</h3>";
        $sm_ids_str = "$sm_id";
        $q6 = "SELECT DISTINCT 
                    smv.smv_id,
                    smv.sm_id,
                    smv.lc_id,
                    smv.smv_title,
                    smv.smv_description,
                    smv.smv_video_url,
                    smv.smv_status,
                    sm.sm_id as sm_id_check,
                    sm.sm_name,
                    sm.sm_desc,
                    sm.sm_course_id,
                    lc.lc_id as lc_id_check,
                    lc.lc_title,
                    lc.lc_description,
                    lc.lc_date,
                    c.course_name
                FROM yn_study_material_videos smv
                INNER JOIN x_edu_study_material sm ON smv.sm_id = sm.sm_id
                LEFT JOIN yn_live_classes lc ON smv.lc_id = lc.lc_id
                LEFT JOIN x_edu_courses c ON sm.sm_course_id = c.course_id
                WHERE smv.sm_id IN ($sm_ids_str)
                AND smv.smv_status = '1'
                AND sm.sm_status = '1'";
        
        $r6 = $pdo->query($q6);
        $all_videos = $r6->fetchAll(PDO::FETCH_ASSOC);
        echo "<pre>";
        print_r($all_videos);
        echo "</pre>";
        echo "<p><strong>Videos Found:</strong> " . count($all_videos) . "</p>";
        
        if (empty($all_videos)) {
            echo "<p style='color:red;'><strong>❌ QUERY RETURNED NO RESULTS!</strong></p>";
        } else {
            echo "<p style='color:green;'><strong>✅ QUERY WORKS! Video should show for user ID: $user_id</strong></p>";
        }
    }
    
} catch(PDOException $e) {
    echo "<h3 style='color:red;'>ERROR:</h3>";
    echo "<p>" . $e->getMessage() . "</p>";
}
?>

